/*****************************************************************************/
/*  FdGetFirstFr.c                                                           */
/*****************************************************************************/

#include <FdGetFirstFr.h>
#include <stdio.h>

/*---------------------------------------------------------------------------*/
FdGetFirstFr* FdGetFirstFrNew(int maxLatency, char* sList)
/*---------------------------------------------------------------------------*/
{
  FdGetFirstFr* gff = (FdGetFirstFr*) calloc(1, sizeof(FdGetFirstFr));
  if(gff == NULL) CfgMsgAddFatal("FdGetFirstFrNew failed");

  gff->lastGpsOut = -1;
  gff->maxLatency = maxLatency;

  /*--------- break the list of input names to single names and count them---*/
  FrTag* tList = FrTagNew(sList); 
  int nSources = 0;
  for(FrTag* t = tList; t != NULL; t = t->next) {nSources++;}
  gff->nSources = nSources; 

  /*------------------------------------------------------allocate buffers---*/
  gff->latencies = (double*)  calloc(nSources,sizeof(double));
  gff->sNames    = (char**)   calloc(nSources, sizeof(char*));
  gff->missingSt = (FRBOOL*)  calloc(nSources, sizeof(FRBOOL));

  gff->serDataSize = 100*nSources;
  gff->serData     = (char*) calloc(gff->serDataSize, sizeof(char));
  gff->status      = (char*) calloc(gff->serDataSize+60, sizeof(char));
  if(gff->latencies  == NULL ||
     gff->sNames     == NULL ||
     gff->missingSt  == NULL ||
     gff->serData    == NULL ||
     gff->status     == NULL)
    CfgMsgAddFatal("FdGetFirstFrNew failed nSource=%d", nSources);

  for(int iSource = 0; iSource<gff->nSources; iSource++) {
      gff->latencies[iSource] = -10;}

  sprintf(gff->status,"FrMerger: starting"); 

  /*------------------------------------------------fill the sources names---*/
  int i = 0;
  for(FrTag* t = tList; t != NULL; t = t->next) {
    FrStrCpy(&(gff->sNames[i]), t->start);
    if(gff->sNames[i] == NULL) CfgMsgAddFatal("FdGetFirstFrNew %d",t->length);
    CfgMsgAddInfo("FdGetFirstFrNew: source %d is %s\n",i,gff->sNames[i]);
    i++;}

  return(gff);
}
/*---------------------------------------------------------------------------*/
FrameH* FdGetFirstFrProc(FdGetFirstFr* gff, FrameH* frame, char* sender)
/*---------------------------------------------------------------------------*/
/* This function takes the first cm input                              */
/*---------------------------------------------------------------------------*/
{
 if(frame == NULL) return(NULL);

  //-------------------------------------check if the frame is part of the list
  double gps = frame->GTimeS + 1.e-9*frame->GTimeN;
  int source;
  for(source = 0; source<gff->nSources; source++) {
    if(strcmp(sender, gff->sNames[source]) == 0) break;}
  if(source >= gff->nSources) {
    CfgMsgAddError("FdGetFirstFrFeed: reject unwanted frame from %s at %.1f",
		   sender, gps);
    FrameFree(frame);
    return(frame);}

  //-----------------------------------find if a source is back sending frames
  if(gff->missingSt[source] == FR_YES) {
    CfgMsgAddInfo("FdGetFirstFrFeed: %.1f receiving again frames from %s ",
                   gps, gff->sNames[source]);
    gff->missingSt[source] = FR_NO;}

  //------------record latency and check if a source is inactive (latency > 50)
  double latency = FrameLatency(frame);
  gff->latencies[source] = latency;
  double latencyMin = 1.e10;
  double latencyMax = 0;
  char* p = gff->serData;

  for(int i = 0; i<gff->nSources; i++) {
    if(gff->latencies[i] < latencyMin) latencyMin = gff->latencies[i];
    if(gff->latencies[i] > latencyMax) latencyMax = gff->latencies[i];
    p += snprintf(p, gff->serDataSize - (p - gff->serData),
	"%s_%s_latency %.3f ", CfgGetCmName(), gff->sNames[i], gff->latencies[i]);

    if(gff->latencies[i] > gff->maxLatency && 
       gff->missingSt[i] == FR_NO) {
       gff->missingSt[i] = FR_YES;
       CfgMsgAddWarning("FdGetFirstFrFeed: %.1f %s start to be missing",
	   gps,  gff->sNames[i]);}}

  //---------------------------------- if this is not the first frame, remove it
  if(gps <= gff->lastGpsOut) {
    FrameFree(frame);
    return(NULL);}
 
  //-------------------------------------------------------returns the new frame 
  gff->lastGpsOut = gps;

  sprintf(gff->status,"input latency: min: %.2f max: %.2f first: %s", 
			latency, latencyMax, gff->sNames[source]);

  return(frame);
}
