/*----------------------------------------------------------------------------*/
/*  This test program retreive the list of channels from a remote Cm process. */
/*  Program argument: the Cm name of the remote process.                      */
/*----------------------------------------------------------------------------*/

#include <stdio.h>
#include <CmMessage.h>
#include "FdUtil.h"

/*----------------------------------------------------------------------------*/
CmMessageStatus ChListHandler (CmMessage message, char* sender, char* serverName)
/*----------------------------------------------------------------------------*/
{
  int  gps       = CmMessageGetInt(message);
  printf("The list of channel provided by %s for %d is:\n", sender, gps);

  printf("----->%s",CmMessageGetText(message));
  int  nChannels = CmMessageGetInt(message);
  char* list     = CmMessageGetText(message);
  printf(" nAdc=%d\n",nChannels);
  if(nChannels > 0) printf(list);

  printf("----->%s",CmMessageGetText(message));
  nChannels = CmMessageGetInt(message);
  list      = CmMessageGetText(message);
  printf(" nProc=%d\n",nChannels);
  if(nChannels > 0) printf(list);

  printf("----->%s",CmMessageGetText(message));
  nChannels = CmMessageGetInt(message);
  list      = CmMessageGetText(message);
  printf(" nSer=%d\n",nChannels);
  if(nChannels > 0) printf(list);

  printf("----->%s",CmMessageGetText(message));
  nChannels = CmMessageGetInt(message);
  list      = CmMessageGetText(message);
  printf(" nSim=%d\n",nChannels);
  if(nChannels > 0) printf(list);

  exit(CmMessageBreak);
}
/*----------------------------------------------------------------------------*/
int main(int argc, char *argv[])  
/*----------------------------------------------------------------------------*/
{
  int irc;

  if (argc < 2 || argc > 3) {
    printf("\n  You need to provide at least 1 argument: the Cm name of the remote process\n");
    printf("  A second optional parameter is the GPS time (for dataSender request\n");
    return(0);}


  CmMessageOpenServer ("FdGetChannelList");

  CmMessageInstallHandler (ChListHandler, "FdChannelsList");

  printf("Ask the channels list to %s\n",argv[1]);

  int gps = 0;
  if(argc == 3) {
    gps = atoi(argv[2]);
    printf(" for GPS=%d\n",gps);}

  irc = FdRequestChannelsList(argv[1], gps);
  if(irc == 0) {
    printf("Could not send request for channel list\n");
    exit(0);}

  CmMessageWait ();

  return(0);
}
