/*----------------------------------------------------------------------*/
#include <stdlib.h>
#include "FdChList.h"

#define CfgMsgAddFatal printf

/*---------------------------------------------------------------------------*/
int main(int argc, char *argv[])  
/*---------------------------------------------------------------------------*/
{
  FrFile *iFile;
  FrameH *frame;
  FdCList *list1, *list2, *listM;

  iFile = FrFileINew("/virgoData/ffl/raw.ffl");
  FrFileISetTime(iFile, FrFileITEnd(iFile)-100);

  frame = FrameRead(iFile);
//  FrameTag(frame,"*a*");
  list1 = FdCListNew();
  list2 = FdCListNew();
  FdCListBuildAdc(list1, frame, 0);

  printf("ADC: \n%s\n",FdCListDump(list1));

  FdCListBuildProc(list1, frame, 0);
  printf("PROC: \n%s\n",FdCListDump(list1));

  FdCListBuildSer(list2, frame, 0);
  printf("SER:\n%s\n",FdCListDump(list2));

  FdCListBuildSim(list2, frame, 0);
  printf("SIM:\n%s\n",FdCListDump(list2));

  frame = FrameRead(iFile);
  FrameTag(frame,"*a*");
  FdCListBuildAdc(list2, frame, 0);
  printf("Next frame---------------\nADC\n%s\n",FdCListDump(list2));

  listM = FdCListMerge(list2, list1, NULL, NULL);
  printf("MERGED:\n%s\n",FdCListDump(listM));

  return(0);
}
 
