/*----------------------------------------------------------------------------*/
/*  FdMoni.c                                                                  */
/* This is an example of very simple application using the Fd library         */
/*----------------------------------------------------------------------------*/

#include "FdIO.h"

struct MyMoniRoot                /* main structure (one per process) */
{
  char *channelName;             /* name of the channel              */
};

/*----------------------------------------------------------------------------*/
void* MyMoniQuitHandler (void *dummy)
/*----------------------------------------------------------------------------*/
{
  CfgMsgAddInfo("Close user code if needed");

  return(NULL);
}
/*----------------------------------------------------------------------------*/
void MyMoniParseIni(FdIO *fd,   struct MyMoniRoot *myMoni)
/*----------------------------------------------------------------------------*/
{
  CbfCleanSetExitFnt((CbfCleanExitFnt_t) MyMoniQuitHandler);

  CfgParseAdd (fd->parser,"CHANNEL_NAME", 1, CfgString, &(myMoni->channelName));

  return;
}
/*----------------------------------------------------------ProcessOneFrame---*/
FrameH* MyMoniProcessOneFrame(FrameH *frame,  struct MyMoniRoot *myMoni)
/*----------------------------------------------------------------------------*/
{
  double latency;
  FrVect *channel;

  /*-----------------------------------get a channel to do some processing---*/ 
  channel = FrameFindVect(frame, myMoni->channelName);
  if(channel == NULL) CfgMsgAddError(" %d could not get channel",frame->GTimeS);
 
  /*---------------------------------------- Print some status information ---*/
  latency = FrameLatency(frame);
  CfgMsgAddUserInfo( "gps:%d-%0.f latency:%.1f ",
		     frame->GTimeS, frame->dt, latency);

  return(frame);
}
/*------------------------------------------------------------------- Main ---*/
int main(int  argc, char *argv[])
/*----------------------------------------------------------------------------*/
{
  struct MyMoniRoot myMoni;
  FrameH *frame;
  FdIO *fdIO;

  fdIO = FdIONew(argc, argv);                 /*-----create the FdIO object---*/
  if(fdIO == NULL) exit(EXIT_FAILURE);

  MyMoniParseIni(fdIO, &myMoni); /*---declare user parsing and quit handler---*/

  FdIOParseAndIni(fdIO);         /*---------------standard parsing and init---*/

  CfgReachState(CfgServerActive);

  while (!CfgFinished()) {   /*---------------------------------- main loop---*/
    frame = FdIOGetFrame(fdIO);
    if(frame == NULL) continue;

    frame = MyMoniProcessOneFrame(frame, &myMoni); /*------- user processing---*/

    FdIOPutFrame(fdIO, frame);}

  return(0);
}
