#include "FdIO.h"

/*-----------------------------------------------declare private functions---*/
typedef struct FdBuffer  FdBuffer;

struct FdBuffer{
  int        size;        /* number of frames stored in the output buffer*/
  int        index;       /* current position in the output buffer */
  FrameH**   list;        /* this is the list of frames */
  FdAction*  action;      /* action object which hold this object */
};
 
void FdBufferProcess(FdBuffer* list, FrameH* frame);
 
/*---------------------------------------------------------------------------*/
int FdBufferNew(void *arg, CfgDataType_t *data)
/*---------------------------------------------------------------------------*/
{
  FdBuffer *buffer;

  /*------------create the object and add it at the end of the linked list---*/
  buffer = (FdBuffer*) calloc(1,sizeof(FdBuffer));
  if(buffer == NULL) CfgMsgAddFatal("malloc FdBuffer failed");

  buffer->action = FdActionNew((FdAction**) arg, 
			       (void*) buffer, FdBufferProcess, "Buffer");
  /*------------------------------------------------------------ fill info---*/
  buffer->size = CfgParseGetNextDec(data);
 
  CfgMsgAddInfo("Delay output frames by %d frames", buffer->size);

  buffer->list = (FrameH **) calloc(buffer->size, sizeof(FrameH *));
  if(buffer->list == NULL) CfgMsgAddFatal("malloc output buffer failed");

  buffer->index = 0;
  
  return(CFG_OK);
}
/*---------------------------------------------------------------------------*/
void FdBufferProcess(FdBuffer *buffer,
		     FrameH* frame)
/*---------------------------------------------------------------------------*/
{
  FdAction *next;

  if(frame != NULL) {
    buffer->list[buffer->index] = frame;
    buffer->index = (buffer->index + 1) % buffer->size;
    frame = buffer->list[buffer->index];}

  next = buffer->action->next;
  if(next != NULL) next->action(next->data, frame);

  return;
}
/*---------------------------------------------------------------------------*/
void FdBufferParserAdd(FdIO* fdIO)
/*---------------------------------------------------------------------------*/
{
   CfgParseGetFunctionAdd(fdIO->parser, "FDOUT_DELAY",
			 FdBufferNew, (void *) &(fdIO->actionsOut), 1,
			 CfgDec);
  return;
}
