/*---------------------------------------------------------------------------*/
/* FdUtil.c    contains the basic tools to sned frames and request over Cm.
   It does not require other FdIO code */
/*----------------------------------------------------------------------------*/

#include "FdUtil.h"
#include <FdIO.h>

/*----------------------------------------------------------------------------*/
 FrameH *FdGetFrameFromMessage (CmMessage message, int compress, int *nBytes)
/*----------------------------------------------------------------------------*/
{
  FrameH *frame;
  char *buf;
  FRLONG *nBytesB;
  int gtimeS;
 
  /*---------------------------------------decode message and extract frame---*/
  CmMessageGetText  (message);          /* for the frame name       */
  CmMessageGetInt   (message);          /* for the old run number   */
  CmMessageGetInt   (message);          /* for the old frame number */
  gtimeS = CmMessageGetInt   (message);          /* for GTimeS               */
  CmMessageGetInt   (message);          /* for GTimeN               */
  CmMessageGetInt   (message);          /* for the trigger number   */
  *nBytes= CmMessageGetInt   (message);
  buf    = CmMessageGetArray (message, CmMessageChar, nBytes);

  nBytesB = (FRLONG*) (buf+*nBytes-28);
  if(*nBytes != *nBytesB) {
    CfgMsgAddError("%d nBytes missmatch for frame message:%d/%ld",
		   gtimeS, *nBytes, *nBytesB);
    return(NULL);}

  frame = FrameReadFromBuf (buf, *nBytes, compress);

  *nBytesB = 0;  /*reset nBytes for meaningful future check*/

  return(frame);
}/*----------------------------------------------------------------------------*/
CmMessage FdPutFrameInMessage(FrameH *frame, 
                             int compress, 
                             int *nBytes,
                             int computeChecksum)
/*----------------------------------------------------------------------------*/
{
  CmMessage message;
  int bufSize;
  char *buf;

  *nBytes = 0;

  message = CmMessageNew();
  if(message == NULL) return(NULL);

  /*-------------------------------start with some guess on the frame size---*/
  bufSize = 1024*1024;

  /*--------------------------------Allocate the buffer and write the frame---*/
  while(1) {
    buf = malloc(bufSize);
    if(buf == NULL) return(NULL);

    *nBytes = FrameWriteToBuf(frame, compress, buf, bufSize, computeChecksum);

    if (*nBytes != 0) break;

    /*-----the buffer is too small, increases its size until the frame fits---*/
    bufSize = 2 * bufSize;
    free(buf);
  }

  /*------------------------------------------------- build the Cm message ---*/
  CmMessagePutText  (message, frame->name);
  CmMessagePutInt   (message, frame->run);
  CmMessagePutInt   (message, frame->frame);
  CmMessagePutInt   (message, frame->GTimeS);
  CmMessagePutInt   (message, frame->GTimeN);
  CmMessagePutInt   (message, (int) 0);
  CmMessagePutInt   (message, *nBytes);
  CmMessagePutArray (message, CmMessageChar, *nBytes, buf);
  CmMessageSetType  (message, "FdFrame");
  CmMessagePutDouble(message, frame->dt);

  return(message);
}
/*----------------------------------------------------------------------------*/
int FdRemoveFramesRequest (char* dest, char* serverName)
/*----------------------------------------------------------------------------*/
{
  int ok;
  CmMessage message;

  message= CmMessageNew();

  CmMessagePutText (message, serverName);

/* Remarque: for a transition persiode, use the pre v8r00 message type ------*/
  CmMessageSetType (message, "FdRemoveFrame");
/*  CmMessageSetType (message, "FdRemoveCmOutput"); this is the new type-----*/

  ok = CmMessageSend (message, dest);

  CmMessageDelete (message);

  return(ok);
}
/*----------------------------------------------------------------------------*/
int FdRequestChannelsList(char *source, int gps)
/*----------------------------------------------------------------------------*/
{
  CmMessage message;
  int irc;

  message = CmMessageNew();
  CmMessagePutInt(message, gps);
  CmMessageSetType(message, "FdGetChannelsList");

  irc = CmMessageSend(message, source);

  CmMessageDelete(message);

  return(irc);
}
/*----------------------------------------------------------------------------*/
int FdRequestFrames(char *source, 
                  char* destination, 
                  char *tag, 
                  int queueSize, 
                  int nRetry)
/*----------------------------------------------------------------------------*/
{
  int ok;
  CmMessage message;

  message= CmMessageNew();

  CmMessagePutText(message, destination);
  CmMessagePutText(message, tag);
  CmMessagePutInt (message, queueSize);
  CmMessagePutInt (message, nRetry);

/* Remarque: for a transition persiode, use the pre v8r00 message type ------*/
  CmMessageSetType (message, "FdAddFrame");
/*  CmMessageSetType (message, "FdRemoveCmOutput"); this is the new type-----*/

  ok = CmMessageSend (message, source);

  CmMessageDelete (message);

  return(ok);
}
