#if !defined(FDIDIR_DEFINED)
#define FDIDIR_DEFINED DONE

#include "FdIO.h"
#include <sys/stat.h>
#include <errno.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct FdIDir  FdIDir;

struct FdIDir{
  char*      nextFile;       /* current/next file name                        */
  FRLONG     tStart;         /* GPS time of the first frame to be read (ms)   */
  FRLONG     tNextFrame;     /* expected GPS time for the next frame (ms)     */
  FRLONG     dtFile;         /* file duration in second (ms)                  */
  int        nFramesPerSec;  /* number of frame per seconds or zero is dt>=1  */
  int        lastMtimeS;     /* last directory modify time (seconds)          */
  int        lastMtimeN;     /* last directory modify time (nanoseconds)      */
  int        timeLastFrame;  /* time of the last frame read                   */
  int        nPrint;         /* number of time some debug info is printed     */
  int        nWarningsPrfx;  /* number of warning for unexpected file print   */
  int        scanMode;       /* -2 = search for the oldest file               */
  int        dtMargin;       // margin added to perform a new directory scan
  char*      dirName;        /* directory name if input from a directory      */
  char*      prefix;         /* file prefix                                   */
  char*      frameInfo;      /* name of the file holding the last frame time  */
  FRBOOL     lastRead;       /* tell if a frame was read during the last call */
  FRBOOL     openError;      /* is the open error message has been printed?   */
  FRBOOL     noFileError;    /* is the no file error message has been printed?*/
  FrFile*    iFile;          /* input frame file                              */
  FdAction*  action;         /* action object                                 */
  FdIDir*    next;           /* next object, used by the frame merger         */
};
 
void    FdIDirFree(FdIDir* iDir);
FdIDir* FdIDirNew(char* dirName, int tStart);
FrameH *FdIDirProcessOne(FdIDir* iDir, int debugLvl);

#ifdef __cplusplus
}
#endif

#endif
