#if !defined(FDGETFIRSTFR_DEFINED)
#define FDGETFIRSTFR_DEFINED DONE

#include <CfgVirgo.h>
#include <CfgParse.h>
#include "FrameL.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct FdGetFirstFr FdGetFirstFr;

struct FdGetFirstFr    
{
  int       maxLatency;  // maximum latency to declare a source lost
  int       nSources;    // number of expected sources 
  double    lastGpsOut;  // GPS time of the last frame outputed 
  char**    sNames;      // list of input sources 
  FRBOOL*   missingSt;   // tell if a frame source is missing or not
  FRBOOL*   missingPr;   // tell if the missing source info has been printed
  double*   latencies;   // array of latencies; size nFrames.nSources 
  char*     serData;     // buffer for the serData 
  int       serDataSize; // size of serData buffer
  char*     status;      // string with the status information
};

FdGetFirstFr* FdGetFirstFrNew(int maxLatency, char* sList);
FrameH*       FdGetFirstFrProc(FdGetFirstFr* gff, FrameH* frameIn, char* sender);
#ifdef __cplusplus
}
#endif

#endif
