#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <CmMessage.h>

/*----------------------------------------------------------------*/
static void WaitSomeSeconds (double seconds)
/*----------------------------------------------------------------*/
{
  static struct timeval timeout;

  timeout.tv_sec = (int) seconds;
  timeout.tv_usec = (int) ((seconds - (int) seconds) * 1000000);
  select (FD_SETSIZE, NULL, NULL, NULL, &timeout);
}

static CmConnectConnectionHandler PreviousHandler = 0;

void disconnection_handler (CmConnect connect)
{
  printf ("disconnection handler\n");
  if (PreviousHandler != 0) PreviousHandler (connect);
}

int main ()
{
  int i;
  CmMessage message;

  if (!CmMessageOpenServer ("sender"))
    {
      fprintf (stderr, "cannot start sender\n");
      exit (1);
    }

  PreviousHandler = CmConnectInstallDisconnectionHandler (
      disconnection_handler);


  message = CmMessageNew ();
  CmMessageSetType (message, "test");
  CmMessagePutText (message, "test");

  for (i=0;i<200;i++)
    {
      if (CmMessageSend (message, "display"))
        {
          printf ("CmMessageSend ok\n");
        }
      else
        {
          printf ("bad send\n");
        }
      WaitSomeSeconds (0.1);
    }

  return EXIT_SUCCESS;
}

