#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
#include <sys/times.h>

#include <CmMessage.h>

static int T = 0;
static int c0;
static double s0;
static double cps = 1.0/60.0;

/*------------------------------------------------*/
static void disconnect (CmConnect c)
/*------------------------------------------------*/
{
  char* name = CmConnectGetName (c);

  printf ("Disconnection of %s\n", name);
}

/*------------------------------------------------*/
static CmMessageStatus stop_handler (CmMessage m, char* sender, char* server)
/*------------------------------------------------*/
{
  printf ("tsb: Stop received\n");

  CmTerminateTransaction (T);

  return (CmMessageOk);
}

/*------------------------------------------------*/
static void send (char* sender,
                  int i,
                  double d,
                  int* array, CmMessageArrayType type, int size)
/*------------------------------------------------*/
{
  CmMessage m;
  struct tms mytms;
  clock_t c;
  double s;

  c = times (&mytms);
  s = (double) (c - c0) * cps;

  m = CmMessageNew ();
  CmMessageSetType (m, "tsb");
  CmMessagePutInt (m, i);
  CmMessagePutDouble (m, d);
  CmMessagePutDouble (m, s);
  CmMessagePutText (m, sender);
  if (array != 0) CmMessagePutArray (m, type, size, array);

  CmMessageSend (m, "tsc");

  CmMessageDelete (m);
}

/*------------------------------------------------*/
static CmMessageStatus handler (CmMessage m, char* sender, char* server)
/*------------------------------------------------*/
{
  int i = CmMessageGetInt (m);
  double d = CmMessageGetDouble (m);
  int* array = 0;
  CmMessageArrayType type;
  int size = 0;

  if (CmMessageGetItemType (m) == CmMessageItemArray)
    {
      array = CmMessageGetArray (m, &type, &size);
    }

  send (sender, i, d, array, type, size);

  return (CmMessageOk);
}

/*------------------------------------------------*/
int main (int argc, char* argv[])
/*------------------------------------------------*/
{
  struct tms mytms;

  CmMessageOpenServer ("tsb");

  CmConnectInstallDisconnectionHandler (disconnect);
  CmMessageInstallHandler (handler, "tsa");
  CmMessageInstallHandler (stop_handler, "stop");

  CmConnectNew ("tsc");

  T = CmOpenTransaction ("tsb", NULL);
  
  c0 = times (&mytms);
  s0 = 0;
  
  CmMessageWait ();

  return EXIT_SUCCESS;
}
