
#include <signal.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <netdb.h>

static int CmConnectDebug = 1;

#define DoPrint printf

/*----------------------------------------------------------------*/
static int TCPSocket ()
/*----------------------------------------------------------------*/
{
  int id;
  int status;
  int option;

  if (CmConnectDebug)
    {
      DoPrint ("socket (%d, %d, 0) -> ", AF_INET, SOCK_STREAM);
    }

  id = socket (AF_INET, SOCK_STREAM, 0);

  if (CmConnectDebug)
    {
      DoPrint ("id = %d\n", id);
    }

  if (id <= 0) return (id);

  if (CmConnectDebug)
    {
      DoPrint ("setsockopt (%d, %d, %d, %p, %zd) -> ", id, SOL_SOCKET,
               SO_REUSEADDR, (void*) &option, sizeof(option));
    }

  option = 1;
  status = setsockopt (id, SOL_SOCKET, SO_REUSEADDR, (void*) &option,
                       sizeof(option));

  if (CmConnectDebug)
    {
      DoPrint ("%d\n", status);
    }

  return (id);
}

/*----------------------------------------------------------------*/
static int TCPBind (int id, struct sockaddr_in* soc)
/*----------------------------------------------------------------*/
{
  int status;
  int length;

  length = sizeof (struct sockaddr_in);

  if (CmConnectDebug)
    {
      DoPrint ("bind (%d, <f=%d p=%d a=%x>, %d) -> ",
               id,
               soc->sin_family,
               ntohs(soc->sin_port),
               soc->sin_addr.s_addr,
               length);
    }

  status = bind (id, (struct sockaddr*) soc, length);

  if (CmConnectDebug)
    {
      DoPrint ("%d errno = %d\n", status, errno);
    }
      
  return (status);
}

/*--------------------------------------------------------------*/
int CmConnectTestPort (int port)
/*--------------------------------------------------------------*/
/*   This function creates a temporary socket, tries a "bind"   */
/* operation upon it, and releases the socket afterward.        */
/*   It returns whether the bind was possible.                  */
/* The socket used for this operation is (should be) reusable.  */
/*--------------------------------------------------------------*/
{
  int id;
  struct sockaddr_in addr;
  int status;

  id = TCPSocket ();
  if (id == 0)
    {
      DoPrint ("Impossible to create a test socket\n");
      return (0);
    }

  addr.sin_port = htons (port);
  addr.sin_addr.s_addr = 0;

  addr.sin_family = AF_INET;
  status = TCPBind (id, &addr);

  status = close (id);
  status = shutdown (id, 2);

  return ((status != -1));
}

int main (int argc, char* argv[])
{
  int port;
  int status;

  if (argc < 2) return (1);

  sscanf (argv[1], "%d", &port);

  status = CmConnectTestPort (port);

  printf ("test port %d -> status = %d errno = %d\n", port, status, errno);

  return EXIT_SUCCESS;
}
