#include <stdio.h>
#include <string.h>

#include <CmMessage.h>

int main (int argc, char* argv[])
{
  CmMessage m = NULL;
  int i;
  int loops = 100;
  char dest[256];
  enum
  {
    create,
    reset
  } mode = reset;

  if (!CmMessageOpenServer ("bench"))
    {
      fprintf (stderr, "Cannot setup Cm\n");
      return (1);
    }

  if (argc < 2)
    {
      fprintf (stderr, "> bench <dest> [ -loops=<loops> ] [ -create ]\n");
      return (1);
    }

  if (argc >= 3)
    {
      sscanf (argv[2], "-loops=%d", &loops);
    }

  if (argc >= 4)
    {
      if (!strcmp (argv[3], "-create"))
        {
          mode = create;
        }
    }

  strcpy (dest, argv[1]);

  if (mode == reset) m = CmMessageNew ();

  for (i = 0; i < loops; i++)
    {
      if (mode == create) m = CmMessageNew ();

      CmMessageSetType (m, "test");
      CmMessagePutText (m, "test");
      if (!CmMessageSend (m, dest))
        {
          break;
        }
      if (mode == reset) CmMessageReset (m);
      else CmMessageDelete (m);
    }

  printf ("Sent %d messages\n", loops);

  return (0);
}
