/*---------------------------------------------------------------------------*/
/*           Copyright (c) 1996 LAL Orsay, IN2P3-CNRS (France).              */
/*                                                                           */
/* Redistribution and use in source and binary forms, with or without        */
/* modification, are permitted provided that the following conditions        */
/* are met:                                                                  */
/* 1. Redistributions of source code must retain the above copyright         */
/*    notice, this list of conditions and the following disclaimer.          */
/* 2. Redistributions in binary form must reproduce the above copyright      */
/*    notice, this list of conditions and the following disclaimer in the    */
/*    documentation and/or other materials provided with the distribution.   */
/* 3. All advertising materials mentioning features or use of this software  */
/*    must display the following acknowledgement:                            */
/*      This product includes software developed by the Computer Application */
/*      Development Group at LAL Orsay (Laboratoire de l'Accelerateur        */
/*      Linaire - IN2P3-CNRS).                                               */
/* 4. Neither the name of the Institute nor of the Laboratory may be used    */
/*    to endorse or promote products derived from this software without      */
/*    specific prior written permission.                                     */
/*                                                                           */
/* THIS SOFTWARE IS PROVIDED BY THE LAL AND CONTRIBUTORS ``AS IS'' AND       */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE     */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        */
/* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LAL OR CONTRIBUTORS BE      */
/* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR       */
/* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF      */
/* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS  */
/* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   */
/* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   */
/* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF    */
/* THE POSSIBILITY OF SUCH DAMAGE.                                           */
/*---------------------------------------------------------------------------*/
#ifndef __LkList__
#define __LkList__

#ifdef vmcms
#include <lkvmdef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*---------------------  Linked lists general stuff   -----------------------*/

typedef struct _LkListRec* LkList;
typedef struct _LkEntryRec* LkEntry;
typedef struct _LkIteratorRec* LkIterator;

typedef void (*LkFunction) (LkEntry This);

/*---------------------------------------------------------------------------*/

void LkListCleanup  ();
LkList LkListNew  ();
void LkListDelete  (LkList This);
void LkListInit  (LkList This);
void LkListConnectEntry  (LkList This, LkEntry entry);
void LkListTransferEntries  (LkList This, LkList dest);
void LkListClear  (LkList This, LkFunction function);
void LkListProcessForward  (LkList This, LkFunction function);
void LkListProcessBackward  (LkList This, LkFunction function);
void LkListSort  (LkList This, LkFunction function);
int LkListContains  (LkList This, LkEntry entry);
int LkListCount  (LkList This);
LkEntry LkListFirstEntry  (LkList This);
LkEntry LkListLastEntry  (LkList This);
LkEntry LkEntryNew  (LkList list, int size);
LkEntry LkEntryInsertNew  (LkEntry before, LkEntry after, int size);
void LkEntryInit  (LkEntry This, LkList list);
void LkEntryDelete  (LkEntry This);
void LkEntryMove  (LkEntry This, LkEntry before, LkEntry after);
void LkEntryDisconnect  (LkEntry This);
void LkEntryTransfer  (LkEntry This, LkList destList, LkEntry before,  LkEntry after);
int LkEntryPosition  (LkEntry This);
LkEntry LkEntryPrevious  (LkEntry This);
LkEntry LkEntryNext  (LkEntry This);
LkList LkEntryFather  (LkEntry This);
LkIterator LkIteratorNew  (LkList list);
void LkIteratorDelete  (LkIterator This);
void LkIteratorReset  (LkIterator This);
LkEntry LkIteratorNext  (LkIterator This);
LkEntry LkIteratorPrevious  (LkIterator This);

#ifdef __cplusplus
}
#endif

#endif
