/*---------------------------------------------------------------------------*/
/*           Copyright (c) 1996 LAL Orsay, IN2P3-CNRS (France).              */
/*                                                                           */
/* Redistribution and use in source and binary forms, with or without        */
/* modification, are permitted provided that the following conditions        */
/* are met:                                                                  */
/* 1. Redistributions of source code must retain the above copyright         */
/*    notice, this list of conditions and the following disclaimer.          */
/* 2. Redistributions in binary form must reproduce the above copyright      */
/*    notice, this list of conditions and the following disclaimer in the    */
/*    documentation and/or other materials provided with the distribution.   */
/* 3. All advertising materials mentioning features or use of this software  */
/*    must display the following acknowledgement:                            */
/*      This product includes software developed by the Computer Application */
/*      Development Group at LAL Orsay (Laboratoire de l'Accelerateur        */
/*      Linaire - IN2P3-CNRS).                                               */
/* 4. Neither the name of the Institute nor of the Laboratory may be used    */
/*    to endorse or promote products derived from this software without      */
/*    specific prior written permission.                                     */
/*                                                                           */
/* THIS SOFTWARE IS PROVIDED BY THE LAL AND CONTRIBUTORS ``AS IS'' AND       */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE     */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        */
/* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LAL OR CONTRIBUTORS BE      */
/* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR       */
/* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF      */
/* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS  */
/* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   */
/* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   */
/* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF    */
/* THE POSSIBILITY OF SUCH DAMAGE.                                           */
/*---------------------------------------------------------------------------*/
/* 
        Hash.h
         Created           :  7-OCT-1992 by Christian Arnault
*/
#ifndef __Hash__
#define __Hash__

#ifdef vmcms
#include <hvmdef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*- Public definitions -----------------------------------------------*/
typedef char* HReference;
typedef char* (*HNamer) (HReference ref);
typedef void (*HFunction) (HReference ref);

typedef struct _HTableRec* HTable;
typedef struct _HIteratorRec* HIterator;

/*---------------------------------------------------------------------*/

void HTableCleanup  ();
HTable HTableNew  (int size, HNamer namer);
void HTableDelete  (HTable This);
void HTableClear  (HTable This, HFunction clear);
void HTableProcess  (HTable This, HFunction action);
int HTableEncode  (HTable This, char* name);
int HTablePosition  (HTable This, char* name);
int HTablePositions  (HTable This, int code);
HReference HTableFindReference  (HTable This, char* name);
HReference HTableGetReference  (HTable This, int code, int position);
void HTableAddReference  (HTable This, HReference reference);
void HTableRemoveReference  (HTable This, HReference reference);
HIterator HIteratorNew  (HTable table);
void HIteratorDelete  (HIterator This);
void HIteratorReset  (HIterator This);
HReference HIteratorNext  (HIterator This);
HReference HIteratorPrevious  (HIterator This);

#ifdef __cplusplus
}
#endif

#endif
