#!/bin/sh

test1 ()
{
  echo ""
  echo "============ Test #1 ==================="
  echo ""
  
  ls *.dat | sed 's#.dat$##' | sort >ls$$.txt
  
  ${CMROOT}/${CMCONFIG}/cm.exe names | sort | grep -v '^NameServer$' > names$$.txt
  
  names=`diff ls$$.txt names$$.txt | grep '<' | sed 's#<[ ]##'`
  
  if test ! "${names}" = "" ; then
    for name in ${names} ; do
      echo "> File ${name} not found in Cm names"
    done
  else
    echo "> Db file list strictly corresponds to Cm names"
  fi
  
  rm ls$$.txt names$$.txt
}

test2 ()
{
  echo ""
  echo "============ Test #2 ==================="
  echo ""

  ${CMROOT}/${CMCONFIG}/cm.exe connects | \
   awk -f ${CMROOT}/mgr/check_base.awk 
}

test3 ()
{
  echo ""
  echo "============ Test #3 ==================="
  echo ""

  files=`ls NS*.log | wc -l | sed 's#[ \t]##g`
  size=`du -k . | sed 's#[ 	\.]##g`
  echo "> There are ${files} log files using ${size} Kbytes"
  usage=`df -k . | \
   grep -v Filesystem | \
   awk '{ print $5 " - " $4 " KBytes left";}'`
  echo "> The disk usage is ${usage}"
}
  
infos=`grep '^'"${CMDOMAIN}"'[ ]' $CMROOT/mgr/CmDomains | awk '{print $6;}`
  
cd ${infos}/${CMDOMAIN}

test1
test2
test3


