  /*
    Application looping on operations while being
    listening to incoming messages.
    */

#include <stdio.h>
#include <CmConnect.h>

main ()
{
  CmConnect connect;
  char buffer[256];
  
  CmConnectOpenServer ("Toto");
  
  for (;;)
    {
      CmConnectCheck ();
      
        /*
          In case some messages have been detected by 
          CmConnectCheck, the originating connections
          may have a handler, and it has been already called,
          or if they don't have such handler, they may be
          each interrogated with the CmConnectScan function.
          
          This latter function gives access to connections that
          produced messages while not having a handler, 
          allowing to now receive the message.
          */
      
      connect = NULL;
      while ((connect = CmConnectScan(connect)))
        {
          CmConnectReceive (connect, buffer, sizeof(buffer));
            /* Using the message... */
        }
      
        /* Actual processing loop ... */
    }
}
