#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <CmMessage.h>

static int Transaction = 0;

/*----------------------------------------------------------------*/
CmMessageStatus handler (CmMessage message, char* sender, char* server)
/*----------------------------------------------------------------*/
{
  char* text;

  text = CmMessageGetText (message);

  if (text != 0)
    {
      if (!strcmp (text, "stop"))
        {
          int t;
          CmTransactionStatus status;

          t = CmMessageGetInt (message);
          status = CmTerminateTransaction (t);
          printf ("status terminate = %d for id = %d\n", status, t);
        }
      else
        {
          return (CmMessageBreak);
        }
    }
  return (CmMessageOk);
}

/*----------------------------------------------------------------*/
int main (int argc, char* argv[])
/*----------------------------------------------------------------*/
{
  CmMessageOpenServer ("TTR");

  CmMessageInstallHandler (handler, "ttr");

  Transaction = CmOpenTransaction ("ttr", NULL);

  while (!CmIsTransactionTerminated (Transaction))
    {
      CmMessageWait ();
      printf ("apres wait \n");
      CmDumpTransactions ();
    }

  return EXIT_SUCCESS;
}
