/*---------------------------------------------------------------------------*/
/*        Copyright (c) 1996 LAL Orsay, UPS-IN2P3-CNRS (France).             */
/*                                                                           */
/* Redistribution and use in source and binary forms, with or without        */
/* modification, are permitted provided that the following conditions        */
/* are met:                                                                  */
/* 1. Redistributions of source code must retain the above copyright         */
/*    notice, this list of conditions and the following disclaimer.          */
/* 2. Redistributions in binary form must reproduce the above copyright      */
/*    notice, this list of conditions and the following disclaimer in the    */
/*    documentation and/or other materials provided with the distribution.   */
/* 3. All advertising materials mentioning features or use of this software  */
/*    must display the following acknowledgement:                            */
/*      This product includes software developed by the Computer Application */
/*      Development Group at LAL Orsay (Laboratoire de l'Accelerateur        */
/*      Linaire - UPS-IN2P3-CNRS).                                           */
/* 4. Neither the name of the Institute nor of the Laboratory may be used    */
/*    to endorse or promote products derived from this software without      */
/*    specific prior written permission.                                     */
/*                                                                           */
/* THIS SOFTWARE IS PROVIDED BY THE LAL AND CONTRIBUTORS ``AS IS'' AND       */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE     */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        */
/* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LAL OR CONTRIBUTORS BE      */
/* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR       */
/* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF      */
/* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS  */
/* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   */
/* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   */
/* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF    */
/* THE POSSIBILITY OF SUCH DAMAGE.                                           */
/*---------------------------------------------------------------------------*/
/* 
        xdr.h
         Created           :  7-FEB-1994 by Christian Arnault
*/
 
#ifndef __XDR_HEADER__
#define __XDR_HEADER__

#ifdef __cplusplus
extern "C" {
#endif

enum xdr_op {
  XDR_ENCODE=0,
  XDR_DECODE=1,
  XDR_FREE=2
};

typedef unsigned int u_int;
typedef unsigned long u_long;
typedef unsigned char* caddr_t;
typedef int bool_t;
typedef bool_t (*xdrproc_t)();

typedef struct {
  enum xdr_op x_op;   /* operation; fast additional param */
  struct xdr_ops {
    bool_t  (*x_getlong)();  /* get a long from underlying stream */
    bool_t  (*x_putlong)();  /* put a long to " */
    bool_t  (*x_getbytes)(); /* get some bytes from " */
    bool_t  (*x_putbytes)(); /* put some bytes to " */
    u_int (*x_getpostn)();   /* returns bytes off from beginning */
    bool_t  (*x_setpostn)(); /* lets you reposition the stream */
    long *  (*x_inline)();   /* buf quick ptr to buffered data */
    void  (*x_destroy)();    /* free privates of this xdr_stream */
  } *x_ops;
  caddr_t   x_public;        /* users' data */
  caddr_t   x_private;       /* pointer to private data */
  caddr_t   x_base;          /* private used for position info */
  int   x_handy;             /* extra private word */
} XDR;

u_long rpc$htons();
#define htons rpc$htons

#define xdr_float cm_xdr_float
#define xdr_double cm_xdr_double

int xdrmem_create (XDR* xdrs, caddr_t buffer, int bytes, enum xdr_op op);
int xdr_float (XDR* xdrs, float* f);
int xdr_double (XDR* xdrs, double* d);
int xdr_vector (XDR* xdrs, unsigned char* vector, int elements, int elementSize,
                xdrproc_t action);

#ifdef __cplusplus
}
#endif

#endif
