/*---------------------------------------------------------------------------*/
/*        Copyright (c) 1996 LAL Orsay, UPS-IN2P3-CNRS (France).             */
/*                                                                           */
/* Redistribution and use in source and binary forms, with or without        */
/* modification, are permitted provided that the following conditions        */
/* are met:                                                                  */
/* 1. Redistributions of source code must retain the above copyright         */
/*    notice, this list of conditions and the following disclaimer.          */
/* 2. Redistributions in binary form must reproduce the above copyright      */
/*    notice, this list of conditions and the following disclaimer in the    */
/*    documentation and/or other materials provided with the distribution.   */
/* 3. All advertising materials mentioning features or use of this software  */
/*    must display the following acknowledgement:                            */
/*      This product includes software developed by the Computer Application */
/*      Development Group at LAL Orsay (Laboratoire de l'Accelerateur        */
/*      Linaire - UPS-IN2P3-CNRS).                                           */
/* 4. Neither the name of the Institute nor of the Laboratory may be used    */
/*    to endorse or promote products derived from this software without      */
/*    specific prior written permission.                                     */
/*                                                                           */
/* THIS SOFTWARE IS PROVIDED BY THE LAL AND CONTRIBUTORS ``AS IS'' AND       */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE     */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        */
/* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LAL OR CONTRIBUTORS BE      */
/* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR       */
/* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF      */
/* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS  */
/* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   */
/* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   */
/* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF    */
/* THE POSSIBILITY OF SUCH DAMAGE.                                           */
/*---------------------------------------------------------------------------*/
/* 
        XDR.C
         Created           :  7-FEB-1994 by Christian Arnault
*/
 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#ifndef _WIN32
#include <types.h>
#endif

#include <xdr.h>

static void alphaftoieee (float* f, unsigned char* buffer);
static void alphadtoieee (double* d, unsigned char* buffer);

static void ieeetoalphaf (unsigned char* buffer, float* f);
static void ieeetoalphad (unsigned char* buffer, double* d);

int xdrmem_create (XDR* xdrs, caddr_t buffer, int bytes, enum xdr_op op)
{
  if (!xdrs) return (0);
  
  xdrs->x_op = op;
  xdrs->x_private = buffer;
  xdrs->x_handy = bytes;
  return (1);
}

int cm_xdr_float (XDR* xdrs, float* f)
{
  if (!xdrs) return (0);
  if (!xdrs->x_private) return (0);
  if (!f) return (0);
  if (xdrs->x_handy < sizeof(float)) return (0);

  switch (xdrs->x_op)
  {
    case XDR_ENCODE :
      alphaftoieee (f, xdrs->x_private);
      break;
    case XDR_DECODE :
      ieeetoalphaf (xdrs->x_private, f);
      break;
  }
  xdrs->x_private += sizeof(float);
  xdrs->x_handy   -= sizeof(float);
  return (1);
}

int cm_xdr_double (XDR* xdrs, double* d)
{
  if (!xdrs) return (0);
  if (!xdrs->x_private) return (0);
  if (!d) return (0);
  if (xdrs->x_handy < sizeof(float)) return (0);

  switch (xdrs->x_op)
  {
    case XDR_ENCODE :
      alphadtoieee (d, xdrs->x_private);
      break;
    case XDR_DECODE :
      ieeetoalphad (xdrs->x_private, d);
      break;
  }
  xdrs->x_private += sizeof(double);
  xdrs->x_handy   -= sizeof(double);
  return (1);
}

int xdr_vector (XDR* xdrs, unsigned char* vector, int elements, int elementSize,
                xdrproc_t action)
{
  int elem;
  
  if (!action) return (0);
  
  for (elem = 0; elem < elements; elem++)
  {
    if (!action (xdrs, vector)) return (0);
    vector += elementSize;
  }
  return (1);
}

static void fbits (char* text, unsigned int* ptr)
{
  int bit;
  int expo;
  
  printf ("%10.10s ", text);

  bit = 31;
  printf ("%d", ((ptr[0] & (1<<bit)) != 0));
  printf (" ");

  expo = (ptr[0] << 1) >> 25;
  printf ("%d", expo);

  printf (" ");
  for (bit = 23; bit >= 0; bit--)
  {
    printf ("%d", ((ptr[0] & (1<<bit)) != 0));
  }
  printf ("\n");
}

static void dbits (char* text, unsigned int* ptr)
{
  int bit;
  int expo;
  
  printf ("%10.10s ", text);

  bit = 31;
  printf ("%d", ((ptr[1] & (1<<bit)) != 0));
  printf (" ");

  expo = (ptr[1] << 1) >> 22;
  printf ("%d", expo);

  printf (" ");
  
  for (bit = 20; bit >= 0; bit--)
  {
    printf ("%d", ((ptr[1] & (1<<bit)) != 0));
  }

  for (bit = 31; bit >= 0; bit--)
  {
    printf ("%d", ((ptr[0] & (1<<bit)) != 0));
  }

  printf ("\n");
}

static void fbits0 (char* text, unsigned char* ptr)
{
  int byte;
  
  printf ("%10.10s \n", text);
  
  for (byte = 0; byte < sizeof(float); byte++)
  {
    printf ("%2.2x ", ptr[byte]);
  }

  printf ("\n");
}

static void dbits0 (char* text, unsigned char* ptr)
{
  int byte;
  
  printf ("%10.10s \n", text);
  
  for (byte = 0; byte < sizeof(double); byte++)
  {
    printf ("%2.2x ", ptr[byte]);
  }

  printf ("\n");
}

static void alphaftoieee (float* f, unsigned char* buffer)
{
  int expo;
  unsigned int* word;
  unsigned short* s;
  unsigned short temp;
  unsigned char c;

  memcpy (buffer, f, sizeof(float));
  
  s = (unsigned short*) buffer;

  temp = s[1];
  s[1] = s[0];
  s[0] = temp;
  
  word = (unsigned int*) buffer;

  expo = (word[0] << 1) >> 25;
  expo--;
  word[0] = (word[0] & 0x80ffffff) | (expo << 24);

  c = buffer[0];
  buffer[0] = buffer[3];
  buffer[3] = c;
  
  c = buffer[1];
  buffer[1] = buffer[2];
  buffer[2] = c;
  
}

static void alphadtoieee (double* d, unsigned char* buffer)
{
  int expo;
  unsigned int* word;
  unsigned short* s;
  unsigned short temp;
  unsigned char c;
  
  memcpy (buffer, d, sizeof(double));

  s = (unsigned short*) buffer;

  temp = s[3];
  s[3] = s[0];
  s[0] = temp;

  temp = s[2];
  s[2] = s[1];
  s[1] = temp;

  word = (unsigned int*) buffer;
  
  expo = (word[1] << 1) >> 22;
  expo--;
  
  word[1] = (word[1] & 0x801fffff) | (expo << 21);
  
  c = buffer[0];
  buffer[0] = buffer[7];
  buffer[7] = c;
  
  c = buffer[1];
  buffer[1] = buffer[6];
  buffer[6] = c;
  
  c = buffer[2];
  buffer[2] = buffer[5];
  buffer[5] = c;
  
  c = buffer[3];
  buffer[3] = buffer[4];
  buffer[4] = c;
  
}

static void ieeetoalphaf (unsigned char* buffer, float* f)
{
  int expo;
  unsigned int* word;
  unsigned short* s;
  unsigned short temp;
  unsigned char c;

  c = buffer[0];
  buffer[0] = buffer[3];
  buffer[3] = c;
  
  c = buffer[1];
  buffer[1] = buffer[2];
  buffer[2] = c;
  
  memcpy (f, buffer, sizeof(float));
  
  word = (unsigned int*) f;
  
  expo = (word[0] << 1) >> 25;
  expo++;
  word[0] = (word[0] & 0x80ffffff) | (expo << 24);

  s = (unsigned short*) f;

  temp = s[1];
  s[1] = s[0];
  s[0] = temp;
}

static void ieeetoalphad (unsigned char* buffer, double* d)
{
  int expo;
  unsigned int* word;
  unsigned short* s;
  unsigned short temp;
  unsigned char c;

  c = buffer[0];
  buffer[0] = buffer[7];
  buffer[7] = c;
  
  c = buffer[1];
  buffer[1] = buffer[6];
  buffer[6] = c;
  
  c = buffer[2];
  buffer[2] = buffer[5];
  buffer[5] = c;
  
  c = buffer[3];
  buffer[3] = buffer[4];
  buffer[4] = c;
  
  memcpy (d, buffer, sizeof(double));
  
  word = (unsigned int*) d;
  
  expo = (word[1] << 1) >> 22;
  expo++;
  
  word[1] = (word[1] & 0x801fffff) | (expo << 21);
  
  s = (unsigned short*) d;

  temp = s[3];
  s[3] = s[0];
  s[0] = temp;

  temp = s[2];
  s[2] = s[1];
  s[1] = temp;
}

