/*---------------------------------------------------------------------------*/
/*        Copyright (c) 1996 LAL Orsay, UPS-IN2P3-CNRS (France).             */
/*                                                                           */
/* Redistribution and use in source and binary forms, with or without        */
/* modification, are permitted provided that the following conditions        */
/* are met:                                                                  */
/* 1. Redistributions of source code must retain the above copyright         */
/*    notice, this list of conditions and the following disclaimer.          */
/* 2. Redistributions in binary form must reproduce the above copyright      */
/*    notice, this list of conditions and the following disclaimer in the    */
/*    documentation and/or other materials provided with the distribution.   */
/* 3. All advertising materials mentioning features or use of this software  */
/*    must display the following acknowledgement:                            */
/*      This product includes software developed by the Computer Application */
/*      Development Group at LAL Orsay (Laboratoire de l'Accelerateur        */
/*      Linaire - UPS-IN2P3-CNRS).                                           */
/* 4. Neither the name of the Institute nor of the Laboratory may be used    */
/*    to endorse or promote products derived from this software without      */
/*    specific prior written permission.                                     */
/*                                                                           */
/* THIS SOFTWARE IS PROVIDED BY THE LAL AND CONTRIBUTORS ``AS IS'' AND       */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE     */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        */
/* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LAL OR CONTRIBUTORS BE      */
/* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR       */
/* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF      */
/* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS  */
/* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   */
/* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   */
/* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF    */
/* THE POSSIBILITY OF SUCH DAMAGE.                                           */
/*---------------------------------------------------------------------------*/
#ifndef __Message__
#define __Message__

#include <stdarg.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _CmMessageRec*         CmMessage;
typedef struct _CmMessageIteratorRec* CmMessageIterator;

typedef enum
{
  CmMessageOk,
  CmMessageBreak
} CmMessageStatus;

typedef enum
{
  CmMessageIsDead,
  CmMessageIsNotReady,
  CmMessageIsNew,
  CmMessageIsNotEmpty,
  CmMessageIsClosed,
  CmMessageIsSending
} CmMessageState;

typedef enum
{
  CmMessageChar,
  CmMessageShort,
  CmMessageInt,
  CmMessageFloat,
  CmMessageDouble
} CmMessageArrayType;

typedef enum
{
  CmMessageItemChar,
  CmMessageItemShort,
  CmMessageItemInt,
  CmMessageItemLong,
  CmMessageItemFloat,
  CmMessageItemDouble,
  CmMessageItemArray,
  CmMessageItemText,
  CmMessageItemBytes,
  CmMessageItemTail,
  CmMessageItemUnknown
} CmMessageItemType;

typedef CmMessageStatus (*CmMessageHandler)(CmMessage This,
                                            char* sender,
                                            char* serverName);

typedef char CmMessageItem;

#ifdef __cplusplus
}
#endif

#include <CmConnect.h>
#include <CmTransaction.h>

#ifdef __cplusplus
extern "C" {
#endif

int CmMessageForceStartup  (char* name);
void CmMessageInitialize  ();
int CmMessageStartup  (char* name);
int CmMessageStartupMultiple  (char* name);
int CmMessageOpenServer  (char* name);
int CmMessageOpenMultipleServer  (char* name);
int CmMessageCloseServer  (char* name);
void CmMessageCleanup  ();
void CmMessageCheckBalance  ();
CmConnectPrinter CmMessageInstallPrinter  (CmConnectPrinter printer);
CmMessage CmMessageNew  ();
void CmMessageDelete  (CmMessage message);
void CmMessageReset  (CmMessage message);
void CmMessageSetType  (CmMessage message, char* type);
char* CmMessageGetType  (CmMessage message);
CmMessageState CmMessageGetState  (CmMessage message);
CmConnect CmMessageGetConnect  (CmMessage message);
int CmMessageGetMessageLength  (CmMessage message);
int CmMessageSend  (CmMessage message, char* name);
CmMessageIterator CmMessagePost  (CmMessage message, char* name,                                 CmMessageHandler handler);
void CmMessagePrepareHandler  (CmConnect connect);
CmMessageHandler CmMessageInstallDefaultHandler  (CmMessageHandler function);
CmMessageHandler CmMessageInstallHandler  (CmMessageHandler function,                                          char* type);
void CmMessageUninstallHandler  (char* type);
int CmMessageAreYouThere  (char* name);
CmConnectCondition CmMessageCheck  ();
CmConnectCondition CmMessageWait  ();
CmConnectCondition CmMessageWaitWithTimeout  (double seconds);
CmConnectCondition CmMessageServerCheck  (char* pattern);
CmConnectCondition CmMessageServerWait  (char* pattern);
CmConnectCondition CmMessageServerWaitWithTimeout  (char* pattern,                                                   double seconds);
void CmMessageTraceOn  (int level);
void CmMessageTraceOff  ();
CmMessageItemType CmMessageGetItemType  (CmMessage message);
void CmMessagePutChar  (CmMessage message, char value);
char CmMessageGetChar  (CmMessage message);
void CmMessagePutShort  (CmMessage message, short value);
short CmMessageGetShort  (CmMessage message);
void CmMessagePutInt  (CmMessage message, int value);
int CmMessageGetInt  (CmMessage message);
void CmMessagePutLong  (CmMessage message, long value);
long CmMessageGetLong  (CmMessage message);
void CmMessagePutFloat  (CmMessage message, float value);
float CmMessageGetFloat  (CmMessage message);
void CmMessagePutDouble  (CmMessage message, double value);
double CmMessageGetDouble  (CmMessage message);
void CmMessagePutArray  (CmMessage message, CmMessageArrayType type,                        int elements, void* address);
void CmMessagePutExtArray  (CmMessage message, CmMessageArrayType type,                           int elements, void* address);
void* CmMessageGetArray  (CmMessage message, CmMessageArrayType* typeRef,                         int* elementsRef);
void CmMessagePutText  (CmMessage message, char* value);
char* CmMessageGetText  (CmMessage message);
void CmMessagePutBytes  (CmMessage message, char* value, int length);
char* CmMessageGetBytes  (CmMessage message, int* returnedLength);
void CmMessageIteratorDelete  (CmMessageIterator iterator);
void CmMessageIteratorStop  (CmMessageIterator iterator);
CmMessageStatus CmMessageIteratorCallHandler  (CmMessageIterator iterator);
int CmMessageIteratorFinished  (CmMessageIterator iterator);
void CmMessageIteratorForth  (CmMessageIterator iterator);
CmConnectStatus CmMessageCallHandler  (CmMessage message);

#ifdef __CI_BIND__
CmSwitch (0);
#endif

#ifdef __cplusplus
}
#endif

#endif
