/*---------------------------------------------------------------------------*/
/*        Copyright (c) 1996 LAL Orsay, UPS-IN2P3-CNRS (France).             */
/*                                                                           */
/* Redistribution and use in source and binary forms, with or without        */
/* modification, are permitted provided that the following conditions        */
/* are met:                                                                  */
/* 1. Redistributions of source code must retain the above copyright         */
/*    notice, this list of conditions and the following disclaimer.          */
/* 2. Redistributions in binary form must reproduce the above copyright      */
/*    notice, this list of conditions and the following disclaimer in the    */
/*    documentation and/or other materials provided with the distribution.   */
/* 3. All advertising materials mentioning features or use of this software  */
/*    must display the following acknowledgement:                            */
/*      This product includes software developed by the Computer Application */
/*      Development Group at LAL Orsay (Laboratoire de l'Accelerateur        */
/*      Linaire - UPS-IN2P3-CNRS).                                           */
/* 4. Neither the name of the Institute nor of the Laboratory may be used    */
/*    to endorse or promote products derived from this software without      */
/*    specific prior written permission.                                     */
/*                                                                           */
/* THIS SOFTWARE IS PROVIDED BY THE LAL AND CONTRIBUTORS ``AS IS'' AND       */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE     */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        */
/* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LAL OR CONTRIBUTORS BE      */
/* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR       */
/* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF      */
/* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS  */
/* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   */
/* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   */
/* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF    */
/* THE POSSIBILITY OF SUCH DAMAGE.                                           */
/*---------------------------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

typedef struct _CmMessageRec* CmMessage;
typedef struct _CmMessageIteratorRec* CmMessageIterator;
typedef struct _CmConnectRec* CmConnect;
typedef struct _CvtRec* Cvt;

#include <CmHandle.h>

/*---------------------------------------------------------------------------*/
static List Messages;
static List Connects;
static List Iterators;
static List Cvts;
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
static void initialize ();
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
static void initialize ()
/*---------------------------------------------------------------------------*/
{
  static int first = 1;

  if (first)
    {
      first = 0;

      ListInit (&Messages);
      ListInit (&Connects);
      ListInit (&Iterators);
      ListInit (&Cvts);
    }
}

/*---------------------------------------------------------------------------*/
static void CmHandleClearAll (List* list, void* reference)
/*---------------------------------------------------------------------------*/
{
  Entry* entry;

  entry = list->first;
  while (entry != NULL)
    {
      CmHandle* handle;

      handle = (CmHandle*) entry->reference;
      if (handle != NULL)
        {
          if (handle->reference == reference)
            {
              handle->reference = NULL;
            }
        }

      entry = entry->next;
    }
}










/*---------------------------------------------------------------------------*/
void CmMessageHandleInstall (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;
  handle->reference = NULL;

  initialize ();
  handle->entry = ListAdd (&Messages, handle);
}

/*---------------------------------------------------------------------------*/
void CmMessageHandleUninstall (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;
  handle->reference = NULL;

  initialize ();
  EntryDelete (handle->entry);
}

/*---------------------------------------------------------------------------*/
void CmMessageHandleClear (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;

  handle->reference = NULL;
}

/*---------------------------------------------------------------------------*/
void CmMessageHandleSet (CmHandle* handle, CmMessage message)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;

  handle->reference = message;
}

/*---------------------------------------------------------------------------*/
CmMessage CmMessageHandleGet (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return (NULL);

  return ((CmMessage) handle->reference);
}

/*---------------------------------------------------------------------------*/
void CmMessageHandleClearAll (CmMessage message)
/*---------------------------------------------------------------------------*/
{
  if (message == NULL) return;

  initialize ();
  CmHandleClearAll (&Messages, message);
}





/*---------------------------------------------------------------------------*/
void CmConnectHandleInstall (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;
  handle->reference = NULL;

  initialize ();
  handle->entry = ListAdd (&Connects, handle);
}

/*---------------------------------------------------------------------------*/
void CmConnectHandleUninstall (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;
  handle->reference = NULL;

  initialize ();
  EntryDelete (handle->entry);
}

/*---------------------------------------------------------------------------*/
void CmConnectHandleClear (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;

  handle->reference = NULL;
}

/*---------------------------------------------------------------------------*/
void CmConnectHandleSet (CmHandle* handle, CmConnect connect)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;

  handle->reference = connect;
}

/*---------------------------------------------------------------------------*/
CmConnect CmConnectHandleGet (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return (NULL);

  return ((CmConnect) handle->reference);
}

/*---------------------------------------------------------------------------*/
void CmConnectHandleClearAll (CmConnect connect)
/*---------------------------------------------------------------------------*/
{
  if (connect == NULL) return;

  initialize ();
  CmHandleClearAll (&Connects, connect);
}





/*---------------------------------------------------------------------------*/
void CmCvtHandleInstall (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;
  handle->reference = NULL;

  initialize ();
  handle->entry = ListAdd (&Cvts, handle);
}

/*---------------------------------------------------------------------------*/
void CmCvtHandleUninstall (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;
  handle->reference = NULL;

  initialize ();
  EntryDelete (handle->entry);
}

/*---------------------------------------------------------------------------*/
void CmCvtHandleClear (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;

  handle->reference = NULL;
}

/*---------------------------------------------------------------------------*/
void CmCvtHandleSet (CmHandle* handle, Cvt cvt)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;

  handle->reference = cvt;
}

/*---------------------------------------------------------------------------*/
Cvt CmCvtHandleGet (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return (NULL);

  return ((Cvt) handle->reference);
}

/*---------------------------------------------------------------------------*/
void CmCvtHandleClearAll (Cvt cvt)
/*---------------------------------------------------------------------------*/
{
  if (cvt == NULL) return;

  initialize ();
  CmHandleClearAll (&Cvts, cvt);
}





/*---------------------------------------------------------------------------*/
void CmIteratorHandleInstall (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;
  handle->reference = NULL;

  initialize ();
  handle->entry = ListAdd (&Iterators, handle);
}

/*---------------------------------------------------------------------------*/
void CmIteratorHandleUninstall (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;
  handle->reference = NULL;

  initialize ();
  EntryDelete (handle->entry);
}

/*---------------------------------------------------------------------------*/
void CmIteratorHandleClear (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;

  handle->reference = NULL;
}

/*---------------------------------------------------------------------------*/
void CmIteratorHandleSet (CmHandle* handle, CmMessageIterator iterator)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return;

  handle->reference = iterator;
}

/*---------------------------------------------------------------------------*/
CmMessageIterator CmIteratorHandleGet (CmHandle* handle)
/*---------------------------------------------------------------------------*/
{
  if (handle == NULL) return (NULL);

  return ((CmMessageIterator) handle->reference);
}

/*---------------------------------------------------------------------------*/
void CmIteratorHandleClearAll (CmMessageIterator iterator)
/*---------------------------------------------------------------------------*/
{
  if (iterator == NULL) return;

  initialize ();
  CmHandleClearAll (&Iterators, iterator);
}





