# This file is part of PyCm, a Python interface to the Cm library
#
# Copyright (C) 2020-2021  European Gravitational Observatory
#
# Author list: Franco Carbognani: franco.carbognani@ego-gw.it
#                   Rhys Poulton: poulton@ego-gw.it
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

import os
import sys

#Check if this script is being used directly by the user
if sys.stdin.isatty():
   print("It is suggested that the user not run this scripts as it will be run when this project is built via cmake (which provides the correct location for libraries).")

if(len(sys.argv)!=2):
   raise SystemExit("""ERROR: Incorrect number of arguments passed to the update_bindings.py script
Usage: python3 update_bindings.py <ctypesgen output>
""")

#Add the addtional header functions for c_void and POINTER
addtional_preamble = """
class c_void(Structure):
    # c_void_p is a buggy return type, converting to int, so
    # POINTER(None) == c_void_p is actually written as
    # POINTER(c_void), so it can be treated as a real pointer.
    _fields_ = [("dummy", c_int)]

def POINTER(obj):
    p = ctypes.POINTER(obj)

    # Convert None to a real NULL pointer to work around bugs
    # in how ctypes handles None on 64-bit platforms
    if not isinstance(p.from_param, classmethod) and obj is not None:

        def from_param(cls, x):
            if x is None:
                return cls()
            else:
                return x

        p.from_param = classmethod(from_param)

    return p
"""
print(f"Applying fixes to {sys.argv[1]} ")

#Now edit the generated file to fix the known issues
with open(sys.argv[1],"r+") as output_file:

   content =  output_file.readlines()
   for i in range(len(content)):
       if("from ctypes import *" in content[i]):
           content[i] = "from ctypes import *" + addtional_preamble
       elif("argtypes" in content[i] and "CmMessageHandler" in content[i]):
           content[i] = content[i].replace("CmMessageHandler","POINTER(CmMessageHandler)")
       elif("raise" in content[i] and "=" in content[i]):
           content[i] = content[i].replace("raise","_raise",1)
       elif("self.data = bytes(obj)"  in content[i]):
           content.insert(i+1,"        elif isinstance(obj,str):\n")
           content.insert(i+2,"            self.data = bytes(obj,'utf-8')\n")

   #Re-write the binding with corrections
   output_file.seek(0)
   output_file.writelines(content)