/name/,/owner/ {
  if ($1 == "name") 
    {
      if (n == "") n = 1;
      names[n] = $3;
    }
  else if ($1 == "host") 
    {
      hosts[n] = $3;
      i = index (all_hosts, $3);
      if (i == 0)
	{
	  all_hosts = all_hosts " " $3;
	}
      host = $3;
    }
  else if ($1 == "port") 
    {
      ports[n] = $3;
      p[host] = p[host] " " $3;
      hostindex[host] = hostindex[host] " " n;
    }
  else if ($1 == "owner") 
    {
      owners[n] = $3;
      n++;
    }
}
END {
  nw = split (all_hosts, w); 
  for (i = 1; i <= nw; i++)
    {
      host = w[i];

      ny = split (hostindex[host], y);
      nx = split (p[host], x);

      for (j = 1; j <= nx; j++)
	{
	  port = x[j];
	  used[port] = 0;
	  numbers[port] = "";
	}

      for (j = 1; j <= nx; j++)
	{
	  port = x[j];
	  used[port]++;
	  used_numbers[port] = used_numbers[port] " " y[j];
	}

      ambiguous = 0;

      for (j = 1; j <= nx; j++)
	{
	  port = x[j];

	  # print port " " used_numbers[port];

	  if (used[port] != 1)
	    {
	      ambiguous = 1;

	      print "> Duplicated ports for host " host;
	      nz = split (used_numbers[port], z);
	      for (k = 1; k <= nz; k++)
		{
		  nn = z[k];
		  print "   name " names[nn] \
		    "   port " ports[nn] \
		    "   owner " owners[nn];
		}
	      used[port] = 1;
	    }
	}

      if (ambiguous == 0)
	{
	  print "> " host " has no duplicated port :";
	  print "    ports : " p[host];
	}
    }
}
