#!/bin/sh

if [ -n "$2" ]; then
  line=`grep $2 $CMMGR/CmDomains`
  if [ -n "$line" ]; then
    export CMDOMAIN=$2
    echo "The domain $2 is now configured."
  else
    echo "The domain" $2 "is not defined in the CmDomains file."
    echo "The available domains are defined in $CMMGR/CmDomains : "
    echo ""
    awk '{ print $1; }' $CMMGR/CmDomains
  fi
else
  if [ ! $CMDOMAIN ]; then
    echo "You should define a domain name, either as the argument"
    echo " to this procedure, or as the CMDOMAIN environment variable."
    echo "The available domains are defined in $CMMGR/CmDomains : "
    echo ""
    awk '{ print $1; }' $CMMGR/CmDomains
  else
    echo "The domain ${CMDOMAIN} is now configured."
  fi
fi
