%define nightly %{nil}
%define _sysconfdir %{_prefix}/etc
%define release 1
%define configure_opts %{nil}

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

# -- metadata ---------------

Name: lalinspiral
Version: 5.0.3
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
License: GPLv2+
Source0: https://software.igwn.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
Prefix: %{_prefix}

# -- build requirements -----

# C
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: gsl-devel
BuildRequires: help2man >= 1.37
BuildRequires: liblal-devel >= 7.7.0
BuildRequires: liblalframe-devel >= 3.0.0
BuildRequires: liblalmetaio-devel >= 4.0.0
BuildRequires: liblalsimulation-devel >= 6.2.0
BuildRequires: liblalburst-devel >= 2.0.0
BuildRequires: make
BuildRequires: pkgconfig >= 0.18.0

# swig
BuildRequires: swig >= 3.0.11

# python3x
BuildRequires: python3
BuildRequires: python3-devel
BuildRequires: python3-lal >= 7.7.0
BuildRequires: python3-lalframe >= 3.0.0
BuildRequires: python3-lalmetaio >= 4.0.0
BuildRequires: python3-lalsimulation >= 6.2.0
BuildRequires: python3-lalburst >= 2.0.0
BuildRequires: python3dist(igwn-ligolw)
BuildRequires: python3dist(numpy) >= 1.7
BuildRequires: python3dist(pytest)

# octave
BuildRequires: octave-devel
BuildRequires: lal-octave >= 7.7.0
BuildRequires: lalframe-octave >= 3.0.0
BuildRequires: lalmetaio-octave >= 4.0.0
BuildRequires: lalsimulation-octave >= 6.2.0
BuildRequires: lalburst-octave >= 2.0.0

# -- packages ---------------

# lalinspiral
Summary: LVK Algorithm Inspiral Library
Requires: lib%{name} = %{version}-%{release}
Requires: python3-%{name} = %{version}-%{release}
Requires: python3dist(igwn-segments)
%description
The LVK Algorithm Inspiral Library for gravitational wave data analysis.
This package provides the runtime tools.

# liblalinspiral
%package -n lib%{name}
Summary: LVK Algorithm Inspiral Library - library package
Requires: liblal >= 7.7.0
Requires: liblalburst >= 2.0.0
Requires: liblalframe >= 3.0.0
Requires: liblalmetaio >= 4.0.0
Requires: liblalsimulation >= 6.2.0
Conflicts: %{name} <= 2.0.0-1
%description -n lib%{name}
The LVK Algorithm Inspiral Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL Inspiral library.

# liblalinspiral-devel
%package -n lib%{name}-devel
Summary: Files and documentation needed for compiling programs that use LAL Inspiral
Requires: lib%{name} = %{version}-%{release}
Requires: gsl-devel
Requires: liblal-devel >= 7.7.0
Requires: liblalburst-devel >= 2.0.0
Requires: liblalframe-devel >= 3.0.0
Requires: liblalmetaio-devel >= 4.0.0
Requires: liblalsimulation-devel >= 6.2.0
Provides: %{name}-devel = %{version}-%{release}
Obsoletes: %{name}-devel < 2.0.1-1
%description -n lib%{name}-devel
The LVK Algorithm Inspiral Library for gravitational wave data analysis.
This package contains files needed build applications that use the LAL Inspiral
library.

# python3x-lalinspiral
%package -n python3-%{name}
Summary: Python %{python3_version} bindings for LALInspiral
Requires: lib%{name} = %{version}-%{release}
Requires: python3
Requires: python3-lal >= 7.7.0
Requires: python3-lalframe >= 3.0.0
Requires: python3-lalmetaio >= 4.0.0
Requires: python3-lalsimulation >= 6.2.0
Requires: python3-lalburst >= 2.0.0
Requires: python3dist(igwn-ligolw)
Requires: python3dist(numpy) >= 1.7
Requires: python3dist(tqdm)
%description -n python3-%{name}
This package provides the Python bindings for LALInspiral.

# lalinspiral-octave
%package octave
Summary: Octave bindings for LALInspiral
Requires: lib%{name} = %{version}-%{release}
Requires: octave
Requires: lal-octave >= 7.7.0
Requires: lalburst-octave >= 2.0.0
Requires: lalframe-octave >= 3.0.0
Requires: lalmetaio-octave >= 4.0.0
Requires: lalsimulation-octave >= 6.2.0
%description octave
This package provides the Octave bindings for LALInspiral.

# -- build stages -----------

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
%configure %{configure_opts} --disable-gcc-flags --enable-swig PYTHON=%{__python3}
%{__make} %{?_smp_mflags} V=1

%check
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post -n lib%{name} -p /sbin/ldconfig

%postun -n lib%{name} -p /sbin/ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

# -- files ------------------

%files -n lib%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_libdir}/*.so.*

%files -n lib%{name}-devel
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python3-%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{python3_sitearch}/*
%exclude %{python3_sitearch}/%{name}/*.a

%files octave
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lalinspiral.oct*

%files
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_bindir}/*
%{_mandir}/man1/*
%{_sysconfdir}/*

# -- changelog --------------

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Thu May 01 2025 Adam Mercer <adam.mercer@ligo.org> 5.0.3-1
- Update fot 5.0.3

* Wed Dec 11 2024 Adam Mercer <adam.mercer@ligo.org> 5.0.2-1
- Update for 5.0.2

* Mon Jul 29 2024 Adam Mercer <adam.mercer@ligo.org> 5.0.1-1
- Update for 5.0.1

* Mon Mar 11 2024 Duncan Macleod <duncan.macleod@ligo.org> 5.0.0-1
- Update for 5.0.0

* Fri Oct 20 2023 Adam Mercer <adam.mercer@ligo.org> 4.0.4-1
- Update for 4.0.4

* Fri Oct 06 2023 Adam Mercer <adam.mercer@ligo.org> 4.0.3-1
- Update for 4.0.3

* Mon Apr 24 2023 Adam Mercer <adam.mercer@ligo.org> 4.0.2-1
- Update for 4.0.2

* Thu Apr 06 2023 Adam Mercer <adam.mercer@ligo.org> 4.0.1-1
- Update for 4.0.1

* Mon Feb 06 2023 Adam Mercer <adam.mercer@ligo.org> 4.0.0-1
- Update for 4.0.0

* Mon Sep 05 2022 Adam Mercer <adam.mercer@ligo.org> 3.0.2-1
- Update for 3.0.2

* Thu Aug 18 2022 Adam Mercer <adam.mercer@ligo.org> 3.0.1-1
- Update for 3.0.1

* Tue Aug 02 2022 Adam Mercer <adam.mercer@ligo.org> 3.0.0-1
- Update for 3.0.0

* Thu Mar 03 2022 Adam Mercer <adam.mercer@ligo.rog> 2.0.6-1
- Update for 2.0.6

* Wed Jan 12 2022 Adam Mercer <adam.mercer@ligo.org> 2.0.5-1
- Update for 2.0.5

* Fri Dec 03 2021 Adam Mercer <adam.mercer@ligo.org> 2.0.4-1
- Update for 2.0.4

* Mon May 17 2021 Adam Mercer <adam.mercer@ligo.org> 2.0.3-1
- Update for 2.0.3

* Fri Feb 05 2021 Adam Mercer <adam.mercer@ligo.org> 2.0.2-1
- Update for 2.0.2

* Mon Jan 11 2021 Adam Mercer <adam.mercer@ligo.org> 2.0.1-1
- Update for 2.0.1

* Wed Oct 28 2020 Adam Mercer <adam.mercer@ligo.org> 2.0.0-1
- Update for 2.0.0

* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 1.10.1-1
- Update for 1.10.1

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 1.10.0-2
- Packaging updates

* Tue Nov 26 2019 Adam Mercer <adam.mercer@ligo.org> 1.10.0-1
- O3b release

* Thu May 23 2019 Adam Mercer <adam.mercer@ligo.org> 1.9.0-1
- O3 release

* Mon Feb 25 2019 Adam Mercer <adam.mercer@ligo.org> 1.8.1-1
- ER14 release

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 1.8.0-1
- Pre O3 release

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.7.7-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.7.6-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.7.5-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.7.4-1
- Pre O2 packaging test release
