/*------------------------------------------------------------------*/
/* File: FdSend.c                                                  */
/* Authors:            B.Mours, D.Verkindt (LAPP-Annecy) 21/02/2001 */
/*                                                                  */
/*  This program read frames and send them using Cm                 */
/*  Program arguments:                                              */
/*      - arg1 = server Cm name (local Cm name)                     */
/*      - arg2 = receiver Cm name                                   */
/*      - arg3 = input file name                                    */
/*------------------------------------------------------------------*/

#include "FdUtil.h"


/*------------------------------------------------------------- main ---------*/
int main(int argc, char *argv[]) 
/*------------------------------------------------------------- main ---------*/
{
  FrFile *iFile;
  FrameH *frame;
  int  nBytes;
  CmMessage message;

  if (argc < 4) {
    printf("\n  You need to provide at least 3 arguments: \n"  
	   "   1- your Cm name \n"
	   "   2- the remote Cm name \n"
	   "   3- the input file name\n");
    return(0);}

  /*-------------------------------------------------------open input file ---*/
  iFile = FrFileINew(argv[3]);
  if (iFile == NULL) {
    printf("Error: cannot open input file %s",argv[3]);
    printf("  Last errors are:\n%s",FrErrorGetHistory());
    return(0);}
  iFile->compress = -1;

  /*-------------------------------------------------------------- open Cm ---*/
  if (!CmMessageOpenServer (argv[1])) {
    printf ("Cannot start Cm for local name %s\n",argv[1]);
    return (0);}

  /*--------------------------------------------- read/send all the frames ---*/
  while ((frame = FrameRead(iFile)) != NULL) {
     message = FdPutFrameInMessage(frame, -1, &nBytes, 0);
     printf("Sending Frame %d (%.2fkB) to %s\n", 
	    frame->GTimeS, (double)nBytes/1024., argv[2]);

     CmMessageSend(message, argv[2]);

     CmMessageDelete(message);
     FrameFree(frame);}
       
 return(0);
}

