#include "FdIO.h"

/*-------------------------------------------------------private functions---*/

typedef struct FdChkDup FdChkDup;

struct FdChkDup   
{
  int       dupNameSize;    /* size of the two next array. 
			       If 0 do not check for duplicated channels     */
  char*     dupNames;       /* Hold the current list of duplicated channels  */
  char*     dupNamesLast;   /* Hold the previous list of duplicated channels */
  int       instanceNbr;    /* count the number of FdChkDup instance         */
  int       nDuplicated;    /* number of duplicated channels                 */
  FRBOOL    rmChannels;     /* if = FR_YES duplicated channel are removed    */
  FdAction* action;         /* owner of this action in the main linked list  */
};

void FdChkDupProcess(FdChkDup *chkDup, FrameH* frame);

/*---------------------------------------------------------------------------*/
void FdChkDupIni(FdIO *fdIO)
/*---------------------------------------------------------------------------*/
/*-- this function counts the number of checkDuplicated action instance 
  -- and add a suffix for the SerData name if there are more than one--------*/
{
  FdAction *action;
  FdChkDup *chkDup;
  int nDup = 0;

  /*----------------------------------------------check input actions list---*/
  for(action = fdIO->actionsIn; action != NULL; action = action->next) {
    if(strcmp(action->type,"ChkDup") != 0) continue;
    nDup++;
    if(nDup < 2) continue;

    chkDup = (FdChkDup*) action->data;
    chkDup->instanceNbr = nDup;}

  /*---------------------------------------------check output actions list---*/
  for(action = fdIO->actionsOut; action != NULL; action = action->next) {
    if(strcmp(action->type,"ChkDup") != 0) continue;
    nDup++;
    if(nDup < 2) continue;

    chkDup = (FdChkDup*) action->data;
    chkDup->instanceNbr = nDup;}

  if(nDup > 2) 
    CfgMsgAddInfo(" Duplicated channels will be checked %d times per frame", 
		  nDup);

  return;
} 
/*---------------------------------------------------------------------------*/
int FdChkDupNew(void *arg, CfgDataType_t *data)
/*---------------------------------------------------------------------------*/
{
  FdChkDup *chkDup;

  /*------------create the object and add it at the end of the linked list---*/
  chkDup = (FdChkDup*) calloc(1,sizeof(FdChkDup));
  if(chkDup == NULL) CfgMsgAddFatal("malloc FdChkDup failed");

  chkDup->action = FdActionNew((FdAction**) arg, 
			       (void*) chkDup, FdChkDupProcess, "ChkDup");

  /*------------------------------------------------------------ fill info---*/
  chkDup->dupNameSize = CfgParseGetNextDec(data);
  if(chkDup->dupNameSize <= 0) {
    CfgMsgAddInfo(" Duplicated channel will be not be reported");
    return(CFG_OK);}

  /*---------------------- allocate the buffer for the duplicate channel list*/
  chkDup->dupNames     = malloc(abs(chkDup->dupNameSize));
  chkDup->dupNamesLast = malloc(abs(chkDup->dupNameSize));
  if(chkDup->dupNamesLast == NULL) 
    CfgMsgAddFatal("could not allocate buffer for the check of "
		   "duplicated channels (%d)",abs(chkDup->dupNameSize));
  chkDup->nDuplicated = 0;
  chkDup->dupNames    [0] = '\0';
  chkDup->dupNamesLast[0] = '\0';

  CfgMsgAddInfo("Will check duplicated channel; List limited do %d char.",
                chkDup->dupNameSize);

  return(CFG_OK);
}
/*---------------------------------------------------------------------------*/
void FdChkDupProcessOne(FdChkDup* c, FrameH* frame)
/*---------------------------------------------------------------------------*/
{
  FrCList *list;
  int nDuplicated, nRemoved;

  /*----------- first build the list of duplicate channels (ADC, Ser, Proc)--*/
  list = FrCListBldChannel(frame);
  nDuplicated = FrCListFindDuplicate(list, c->dupNames, abs(c->dupNameSize));

  if(c->rmChannels == FR_YES) {
        nRemoved  = FrameRemoveDuplicatedADC(frame);
        nRemoved += FrameRemoveDuplicatedProc(frame);}
  else  nRemoved = 0;

  FrCListFree(list);

  c->action->state = CfgServerGolden;

  /*--------------------------------------------------update the FrSerData---*/
  if(c->instanceNbr < 2) 
    snprintf(c->action->serData, c->action->serDataSize, "nDuplicatedChnl %d", 
               nDuplicated);
  else
    snprintf(c->action->serData, c->action->serDataSize, "nDuplicatedChnl%d %d", 
	       c->instanceNbr, nDuplicated);

  /*----------------------------------If no reporting is requested, return---*/
  if(c->dupNameSize <= 0) return;

  /*---------------------------------------------------update action state---*/
  if(nDuplicated != 0) c->action->state = CfgServerActive;

  /*-write error message or not according the cases (if space is available)--*/
  if(c->nDuplicated == 0 && nDuplicated == 0) {  /* OK */}

  else if(c->nDuplicated == 0 && nDuplicated != 0) {
    if(c->rmChannels == FR_YES) 
      CfgMsgAddError("At %d start to have %d duplicated channel(s): %s", 
		     frame->GTimeS, nDuplicated, c->dupNames);
    else 
      CfgMsgAddError("At %d start to remove %d duplicated channel(s): %s", 
		     frame->GTimeS, nDuplicated, c->dupNames);}

  else if(c->nDuplicated != 0 && nDuplicated == 0) {
    CfgMsgAddInfo("AT %d there are no more duplicated channels",
		       frame->GTimeS);}

  else if(strcmp(c->dupNamesLast, c->dupNames) != 0 ||
	  c->nDuplicated != nDuplicated) {
    CfgMsgAddError("At %d we have now %d duplicated channel(s): %s", 
		   frame->GTimeS, nDuplicated, c->dupNames);
    if(nRemoved != 0) CfgMsgAddError(" %d removed",nRemoved);}

  strcpy(c->dupNamesLast, c->dupNames);

  c->nDuplicated = nDuplicated;

  /*----------------------------------------------update user info message---*/
  if(nDuplicated == 0)
      c->action->userInfo[0]='\0';
  else 
      snprintf(c->action->userInfo, c->action->userInfoSize,
	"duplicatedChnl: %s", c->dupNames);

  return;
}
/*---------------------------------------------------------------------------*/
void FdChkDupProcess(FdChkDup* c, FrameH* frame)
/*---------------------------------------------------------------------------*/
{
  FdAction *next;

  if(frame != NULL) FdChkDupProcessOne(c, frame);

 /*-------------------------------call the next action in the linked list---*/
  next = c->action->next;
  if(next != NULL) next->action(next->data, frame);

  return;
}
/*---------------------------------------------------------------------------*/
int FdChkRmDupNew(void *arg, CfgDataType_t *data)
/*---------------------------------------------------------------------------*/
{
  FdChkDup *chkDup;
  FdAction **root, *last;
  
  FdChkDupNew(arg, data);

  root = (FdAction**) arg;
  last = FdActionGetLast(*root);
  chkDup = last->data;

  chkDup->rmChannels = FR_YES;

  CfgMsgAddInfo(" Duplicated channels will be removed");

  return(CFG_OK);
}
/*---------------------------------------------------------------------------*/
void FdChkDupParserAdd(FdIO* fdIO)
/*---------------------------------------------------------------------------*/
{
  CfgParseGetFunctionAdd(fdIO->parser,"FDIN_DUPLICATED_CHANNELS_CHECK",
                         FdChkDupNew, (void *) &(fdIO->actionsIn), 
			 1, CfgDec);
  
  CfgParseGetFunctionAdd(fdIO->parser,"FDIN_DUPLICATED_CHANNELS_REMOVE",
                         FdChkRmDupNew, (void *) &(fdIO->actionsIn), 
			 1, CfgDec);
  
  CfgParseGetFunctionAdd(fdIO->parser,"FDOUT_DUPLICATED_CHANNELS_CHECK",
			 FdChkDupNew, (void *) &(fdIO->actionsOut),
			 1, CfgDec);

  CfgParseGetFunctionAdd(fdIO->parser,"FDOUT_DUPLICATED_CHANNELS_REMOVE",
                         FdChkRmDupNew, (void *) &(fdIO->actionsIn), 
			 1, CfgDec);
  
  return;
}
