/*----------------------------------------------------------------------------*/
/*  This example program asks for frames and put them in memory               */
/*  Program arguments: Cm name of the source and the requested channels names */
/*----------------------------------------------------------------------------*/

#include "FdUtil.h"

FrFile *MFFile = NULL;
double  MFRequestedTSpan;

/*----------------------------------------------------------------------------*/
CmMessageStatus HandlerFrame(CmMessage message, 
		             char* sender,
			     char* serverName)
/*----------------------------------------------------------------------------*/
/* this handler take the frame buffer in put in the in-memory file            */
/*----------------------------------------------------------------------------*/
{
  int run, fnum, gtimeS, gtimeN, trig, nBytes;
  char *buf, *name;
  double tSpan;
 
  name   = CmMessageGetText  (message);
  run    = CmMessageGetInt   (message);
  fnum   = CmMessageGetInt   (message);
  gtimeS = CmMessageGetInt   (message);
  gtimeN = CmMessageGetInt   (message);
  trig   = CmMessageGetInt   (message);
  nBytes = CmMessageGetInt   (message);
  buf    = CmMessageGetArray (message, CmMessageChar, &nBytes);

  printf("--------receiving frame %s %d %d\n", name, gtimeS, gtimeN);
  printf("    obsolete data: run=%d fnum=%d trig=%d\n", run, fnum, trig);

  tSpan = FrFileIInMemoryAddBuffer(MFFile, buf, nBytes, MFRequestedTSpan);
 
  if(tSpan <= 0) printf("Could not get frame %d from %s", gtimeS, sender);

  return(CmMessageBreak);
}
/*----------------------------------------------------------------------------*/
int main(int argc, char *argv[])  
/*----------------------------------------------------------------------------*/
{
  double tLast, tStart, tEnd, dt;
  FrVect *vect;

  if (argc != 3) {
    printf("You need to provide the Cm name of the remote process "
	   "and the name of the requested channel\n");
   return(0);}

  printf("-------------------open the InMemory file\n");
  dt = 10;
  MFRequestedTSpan = 2*dt;
  MFFile = FrFileIInMemoryNew();

  printf("---------------Start Cm\n");
  char *myName = "FdTestInMemoryFrames";
  CmMessageOpenServer (myName);

  CmMessageInstallHandler (HandlerFrame, "FdFrame");

  printf("---------------Ask %s to provide frames containing %s\n",
	 argv[1], argv[2]);
  FdRequestFrames (argv[1], myName, argv[2], 5, 0);


  printf("--------------Wait for enough data to get 10 s. vector\n");
  tLast = 0;
  dt = 10;

  while(0) {
    CmMessageWaitWithTimeout(5);
    tStart = FrFileITStart(MFFile); 
    tEnd   = FrFileITEnd(MFFile);
    printf(" Data available from %.0f to %.0f\n", tStart, tEnd); 
    if(tStart < 1) continue;

    if(tLast == 0) tLast = tStart;
    if(tLast + dt > tEnd) continue;  
    vect = FrFileIGetVect(MFFile, argv[2], tLast, dt);
    FrVectDump(vect, stdout, 2);
    tLast += dt;}
 
  return(0);
}
