#include <CmMessage.h>
#include <time.h>
#include <sys/types.h>
#include <sys/times.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static int connected;
static int c0;
static double s0;
static double cps = 1.0/60.0;

/*------------------------------------------------*/
static void disconnect (CmConnect c)
/*------------------------------------------------*/
{
  char* name = CmConnectGetName (c);

  printf ("Disconnection of %s\n", name);
  if ((name != 0) && (!strcmp (name, "tsb")))
    {
      connected = 0;
    }
}

/*------------------------------------------------*/
static CmMessageStatus stop_handler (CmMessage m, char* sender, char* server)
/*------------------------------------------------*/
{
  printf ("tsc: Stop received\n");

  return (CmMessageBreak);
}



/*------------------------------------------------*/
static void send (char* sender,
                  int i,
                  double d1,
                  double d2,
                  int* array, CmMessageArrayType type, int size)
/*------------------------------------------------*/
{
  CmMessage m;
  struct tms mytms;
  clock_t c;
  double s;

  c = times (&mytms);
  s = (double) (c - c0) * cps;

  m = CmMessageNew ();
  CmMessageSetType (m, "ack");
  CmMessagePutInt (m, i);
  CmMessagePutDouble (m, d1);
  CmMessagePutDouble (m, d2);
  CmMessagePutDouble (m, s);
  if (array != 0) CmMessagePutArray (m, type, size, array);

  CmMessageSend (m, sender);

  CmMessageDelete (m);
}

/*------------------------------------------------*/
static CmMessageStatus handler (CmMessage m, char* sender, char* server)
/*------------------------------------------------*/
{
  int index = 0;

  int i = CmMessageGetInt (m);
  double d1 = CmMessageGetDouble (m);
  double d2 = CmMessageGetDouble (m);
  char* s = CmMessageGetText (m);
  int* array = 0;
  CmMessageArrayType type;
  int size = 0;

  if (CmMessageGetItemType (m) == CmMessageItemArray)
    {
      array = CmMessageGetArray (m, &type, &size);
    }

  if (s != 0) sscanf (s, "tsa_%d", &index);

  if ( connected == 1) {
     send (s, i, d1, d2, array, type, size);
  }

  if ((i % 1000) == 0)
    {
      printf ("Received %d at %lg from %s\n", i, d1, s);
    }


  return (CmMessageOk);
}

/*------------------------------------------------*/
int main (int argc, char* argv[])
/*------------------------------------------------*/
{
  struct tms mytms;

  connected = 1;

  CmMessageOpenServer ("tsc");

  CmConnectInstallDisconnectionHandler (disconnect);
  CmMessageInstallHandler (handler, "tsb");
  CmMessageInstallHandler (stop_handler, "stop");

  c0 = times (&mytms);
  s0 = 0;

  CmMessageWait ();

  return EXIT_SUCCESS;
}

