/*---------------------------------------------------------------------------*/
/*        Copyright (c) 1996 LAL Orsay, UPS-IN2P3-CNRS (France).             */
/*                                                                           */
/* Redistribution and use in source and binary forms, with or without        */
/* modification, are permitted provided that the following conditions        */
/* are met:                                                                  */
/* 1. Redistributions of source code must retain the above copyright         */
/*    notice, this list of conditions and the following disclaimer.          */
/* 2. Redistributions in binary form must reproduce the above copyright      */
/*    notice, this list of conditions and the following disclaimer in the    */
/*    documentation and/or other materials provided with the distribution.   */
/* 3. All advertising materials mentioning features or use of this software  */
/*    must display the following acknowledgement:                            */
/*      This product includes software developed by the Computer Application */
/*      Development Group at LAL Orsay (Laboratoire de l'Accelerateur        */
/*      Linaire - UPS-IN2P3-CNRS).                                           */
/* 4. Neither the name of the Institute nor of the Laboratory may be used    */
/*    to endorse or promote products derived from this software without      */
/*    specific prior written permission.                                     */
/*                                                                           */
/* THIS SOFTWARE IS PROVIDED BY THE LAL AND CONTRIBUTORS ``AS IS'' AND       */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE     */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        */
/* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LAL OR CONTRIBUTORS BE      */
/* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR       */
/* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF      */
/* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS  */
/* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   */
/* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   */
/* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF    */
/* THE POSSIBILITY OF SUCH DAMAGE.                                           */
/*---------------------------------------------------------------------------*/
#ifdef vms
#define FD_ZERO(p)      memset((char *)(p), 0, sizeof(*(p)))
#define fd_set Fd_set
#include <time.h>
#include <fd.h>
#include <socket.h>
#include <inet.h>
#include <ucx$inetdef.h>

#ifdef __ALPHA
#ifndef htons
u_long rpc$htons();
#define htons rpc$htons
#endif
#endif

#else

#ifdef LYNXOS
#define TSVME13x 1
#include <headers_30/conf.h>
#include <headers_30/param.h>
#include <headers_30/absolute.h>
#define FD_SETSIZE USR_NFDS
#define howmany(x,y) (((x)+((y)-1))/(y))
#endif
#ifdef LYNXOSCES
#include <conf.h>
#include <param.h>
#include <absolute.h>
#define FD_SETSIZE USR_NFDS
#define howmany(x,y) (((x)+((y)-1))/(y))
#endif

#ifdef OS9
#include <types.h>
#include <rpc/types.h>
#include <time.h>
#include <socket.h>
#include <in.h>
#include <select.h>
#else
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#endif
#include <signal.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <netdb.h>

int main (int argc, char* argv[])
{
  struct hostent* entry;

  argc--;
  argv++;

  while (argc > 0)
    {
      char* arg = argv[0];
  
      if (!(entry = gethostbyname (arg)))
        {
          printf ("error\n");
        }
      else
        {
          char** aliases = entry->h_aliases;
          int i;

          printf ("h_name = %s\n", entry->h_name);

          i = 0;
          while ((aliases != 0) && (*aliases != 0))
            {
              char* alias = *aliases;
              printf ("h_aliases[%d] = %s\n", i, alias);
              aliases++;
            }

          printf ("h_addr = %d.%d.%d.%d\n",
                  (unsigned char) entry->h_addr[0],
                  (unsigned char) entry->h_addr[1],
                  (unsigned char) entry->h_addr[2],
                  (unsigned char) entry->h_addr[3]);
        }

      argc--;
      argv++;
    }

  return EXIT_SUCCESS;
}
