/*---------------------------------------------------------------------------*/
/*        Copyright (c) 1996 LAL Orsay, UPS-IN2P3-CNRS (France).             */
/*                                                                           */
/* Redistribution and use in source and binary forms, with or without        */
/* modification, are permitted provided that the following conditions        */
/* are met:                                                                  */
/* 1. Redistributions of source code must retain the above copyright         */
/*    notice, this list of conditions and the following disclaimer.          */
/* 2. Redistributions in binary form must reproduce the above copyright      */
/*    notice, this list of conditions and the following disclaimer in the    */
/*    documentation and/or other materials provided with the distribution.   */
/* 3. All advertising materials mentioning features or use of this software  */
/*    must display the following acknowledgement:                            */
/*      This product includes software developed by the Computer Application */
/*      Development Group at LAL Orsay (Laboratoire de l'Accelerateur        */
/*      Linaire - UPS-IN2P3-CNRS).                                           */
/* 4. Neither the name of the Institute nor of the Laboratory may be used    */
/*    to endorse or promote products derived from this software without      */
/*    specific prior written permission.                                     */
/*                                                                           */
/* THIS SOFTWARE IS PROVIDED BY THE LAL AND CONTRIBUTORS ``AS IS'' AND       */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE     */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        */
/* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LAL OR CONTRIBUTORS BE      */
/* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR       */
/* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF      */
/* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS  */
/* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   */
/* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   */
/* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF    */
/* THE POSSIBILITY OF SUCH DAMAGE.                                           */
/*---------------------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>

#include <CmMessage.h>

CmMessageStatus MyHandler (CmMessage message, char* sender, char* serverName);

int main (int argc, char* argv[])
{
  int       total = 0;
  CmConnect connect;
  CmMessage  message;
  int       counter;
  char      buffer[256];
  char*     env;
  int       loops;

  if (argc < 2)
    {
      fprintf (stderr, "Utilisation : %s <MyName> [<OtherName> ...]\n",
	       argv[0]);
      exit (1);
    }

  /*
     
     A call to CmMessageStartup is needed to declare 
     this application as a server, able to receive messages
     The argument is the name known by the system of this
     server.
     
     */
  
  if (!CmMessageOpenMultipleServer (argv[1]))
    {
      CmConnectCleanup ();
      return (0);
    }

  CmServerSetComment ("test");

  
  /*
     
     An automatic reception handler may be installed in order
     to manage any message received.
     
     */
  
  /*
     CmMessageInstallDefaultHandler (MyHandler);
     */
  CmMessageInstallHandler ((CmMessageHandler) MyHandler, "Z");
  
  
  /*
     If no receiver is specified we act as a pure server,
     just listening until anything happens.
     */
  
  if (argc == 2)
    {
      CmMessageWait ();
      connect = CmConnectScan (NULL);
      if (connect) fprintf (stderr, "Probleme avec %s.\n", 
			    CmConnectGetName (connect));
      
      CmMessageCleanup ();
      exit (1);
    }
  
  /*
     Receivers have been specified on the command line.
     We build dummy messages, and send them to all the
     reveivers.
     
     We create a Message object, that will be used to 
     build up the messages. Since we send the same message
     to all the receivers, we just need one message.
     */
  
  env = getenv ("CMTESTLOOPS");
  if (env)
    {
      sscanf (env, "%d", &loops);
    }
  else
    loops = 37;
  
  message = CmMessageNew ();
  counter = 0;
  for (; counter < loops;)
    {
      int i;
      static char carray[] = {0, 1, 2, 3, 4, 5};
      static int iarray[] = {0, 1, 2, 3, 4};
      static double darray[] = {111.111, 222.222, 333.333, 444.444};
      static double big_array[30000];
      
      /* Filling the buffer with numbers in sequence. */
      
      for (i = 0; i < ((counter % 40) + 10); i++)
	{
	  buffer[i] = (i % 10) + '0';
	}
      
      buffer[i++] = 0;

      CmMessageReset     (message);
      
      CmMessagePutText   (message, buffer);
      CmMessagePutChar   (message, (char) 12);
      CmMessagePutShort  (message, (short) 1234);
      CmMessagePutInt    (message, (int) 12345678);
      CmMessagePutLong   (message, (long) 12345678);
      CmMessagePutFloat  (message, (float) 123.456);
      CmMessagePutDouble (message, (double) 123456.789123);

      CmMessagePutArray  (message, CmMessageChar,
			     sizeof(carray),
			     (void*) carray);
      CmMessagePutArray  (message, CmMessageInt,
			     sizeof(iarray)/sizeof(int),
			     (void*) iarray);
      CmMessagePutArray  (message, CmMessageDouble,
			     sizeof(darray)/sizeof(double),
			     (void*) darray);
      
      CmMessagePutArray  (message, CmMessageDouble,
			     sizeof(big_array)/sizeof(double),
			     (void*) big_array);
      
      CmMessagePutExtArray  (message, CmMessageChar,
			     sizeof(carray),
			     (void*) carray);
      CmMessagePutExtArray  (message, CmMessageInt,
			     sizeof(iarray)/sizeof(int),
			     (void*) iarray);
      CmMessagePutExtArray  (message, CmMessageDouble,
			     sizeof(darray)/sizeof(double),
			     (void*) darray);
      
      CmMessagePutExtArray  (message, CmMessageDouble,
			     sizeof(big_array)/sizeof(double),
			     (void*) big_array);
      
      if (!(counter % 10)) CmMessageSetType (message, "Z");
      else CmMessageSetType (message, "X");
      
      /* Sending this message to all the receivers */
      for (i = 2; i < argc; i++)
	{
	  
	  /*
	     We have to check the possible occurrence of external
	     messages, while we loop on sending. (These messages may 
	     be either user messages, sent by applications, or service
	     messages such as disconnections.
	     
	     Messages handled by an automatic handler will be handled
	     internally then. Other messages will setup the list of 
	     sources that may be scanned by CmConnectScan. Here we 
	     assume that any message is handled internally.
	     */
	  
	  CmMessageCheck ();
	  if (CmConnectScan (NULL))
	    {
	      puts ("Probleme de connection.");
	      return (1);
	    }
	  
	  if (!CmMessageSend (message, argv[i])) 
	    {
	      puts ("Probleme avec le destinataire.");
	    }
	  else
	    {
	      fprintf (stderr, "%6.6d %s> J'ai envoye %s.\n",
		       total, argv[i], buffer);
	      total++;
	    }
          counter++;
	}
    }
  CmMessageDelete (message);
  CmMessageCleanup ();
  CmMessageCheckBalance ();

  return EXIT_SUCCESS;
}

CmMessageStatus MyHandler (CmMessage message, char* sender, char* serverName)
{
  char* text;
  static int total = 0;
  char c;
  short s;
  int i;
  long l;
  float f;
  double d;
  CmMessageArrayType type;
  int elements;
  char* carray;
  int* iarray;
  double* darray;

  text = CmMessageGetText (message);
  fprintf (stderr, "  %6.6d %s> %s received %s.\n", total, serverName,
           sender, text);
  c = CmMessageGetChar   (message);
  s = CmMessageGetShort  (message);
  i = CmMessageGetInt    (message);
  l = CmMessageGetLong   (message);
  f = CmMessageGetFloat  (message);
  d = CmMessageGetDouble (message);

  fprintf (stderr, "... %d %d %d %ld %e %e\n", c, s, i, l, f, d);
  
  carray = (char*) CmMessageGetArray (message, &type, &elements);
  
  if (type == CmMessageChar)
    {
      int elem;
      
      fprintf (stderr, "From PutArray ... ");
      for (elem = 0; elem < elements; elem++)
	{
	  fprintf (stderr, "%d ", carray[elem]);
	}
      fprintf (stderr, "\n");
    }

  iarray = (int*) CmMessageGetArray (message, &type, &elements);
  
  if (type == CmMessageInt)
    {
      int elem;
      
      fprintf (stderr, "From PutArray ... ");
      for (elem = 0; elem < elements; elem++)
	{
	  fprintf (stderr, "%d ", iarray[elem]);
	}
      fprintf (stderr, "\n");
    }

  darray = (double*) CmMessageGetArray (message, &type, &elements);
  
  if (type == CmMessageDouble)
    {
      int elem;

      fprintf (stderr, "From PutArray ... ");
      for (elem = 0; elem < elements; elem++)
	{
	  fprintf (stderr, "%g ", darray[elem]);
	}
      fprintf (stderr, "\n");
    }

  CmMessageGetArray (message, &type, &elements);
  
  if (type == CmMessageDouble)
    {
      fprintf (stderr, "From PutArray double ... %d elements received\n", elements);
    }

  
  carray = (char*) CmMessageGetArray (message, &type, &elements);

  if (type == CmMessageChar)
    {
      int elem;
      
      fprintf (stderr, "From PutExtArray ... ");
      for (elem = 0; elem < elements; elem++)
	{
	  fprintf (stderr, "%d ", carray[elem]);
	}
      fprintf (stderr, "\n");
    }

  iarray = (int*) CmMessageGetArray (message, &type, &elements);
  
  if (type == CmMessageInt)
    {
      int elem;
      
      fprintf (stderr, "From PutExtArray ... ");
      for (elem = 0; elem < elements; elem++)
	{
	  fprintf (stderr, "%d ", iarray[elem]);
	}
      fprintf (stderr, "\n");
    }

  darray = (double*) CmMessageGetArray (message, &type, &elements);
  
  if (type == CmMessageDouble)
    {
      int elem;

      fprintf (stderr, "From PutExtArray ... ");
      for (elem = 0; elem < elements; elem++)
	{
	  fprintf (stderr, "%g ", darray[elem]);
	}
      fprintf (stderr, "\n");
    }

  CmMessageGetArray (message, &type, &elements);
  
  if (type == CmMessageDouble)
    {
      fprintf (stderr, "From PutExtArray double ... %d elements received\n", elements);
    }

  total++;

  return (CmMessageOk);
}

