/*---------------------------------------------------------------------------*/
/*        Copyright (c) 1996 LAL Orsay, UPS-IN2P3-CNRS (France).             */
/*                                                                           */
/* Redistribution and use in source and binary forms, with or without        */
/* modification, are permitted provided that the following conditions        */
/* are met:                                                                  */
/* 1. Redistributions of source code must retain the above copyright         */
/*    notice, this list of conditions and the following disclaimer.          */
/* 2. Redistributions in binary form must reproduce the above copyright      */
/*    notice, this list of conditions and the following disclaimer in the    */
/*    documentation and/or other materials provided with the distribution.   */
/* 3. All advertising materials mentioning features or use of this software  */
/*    must display the following acknowledgement:                            */
/*      This product includes software developed by the Computer Application */
/*      Development Group at LAL Orsay (Laboratoire de l'Accelerateur        */
/*      Linaire - UPS-IN2P3-CNRS).                                           */
/* 4. Neither the name of the Institute nor of the Laboratory may be used    */
/*    to endorse or promote products derived from this software without      */
/*    specific prior written permission.                                     */
/*                                                                           */
/* THIS SOFTWARE IS PROVIDED BY THE LAL AND CONTRIBUTORS ``AS IS'' AND       */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE     */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        */
/* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LAL OR CONTRIBUTORS BE      */
/* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR       */
/* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF      */
/* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS  */
/* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   */
/* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   */
/* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF    */
/* THE POSSIBILITY OF SUCH DAMAGE.                                           */
/*---------------------------------------------------------------------------*/
#ifndef __CmHandle_h__
#define __CmHandle_h__

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _List List;
typedef struct _Entry Entry;

typedef struct _CmHandle
{
  Entry* entry;
  void* reference;
} CmHandle;

/*---------------------  Linked lists general stuff  --------------------*/

struct _List 
{
  Entry* first;
  Entry* last;
};

struct _Entry
{
  Entry* previous;
  Entry* next;
  List* list;
  void* reference;
};

/*=======================================================================*/
/*                                                                       */
/*  List                                                                 */
/*                                                                       */
/*=======================================================================*/

/*-----------------------------------------------------------------------*/
inline static void ListInit (List* list)
/*-----------------------------------------------------------------------*/
{
  if (list == NULL) return;
  
  list->first = NULL;
  list->last = NULL;
}
 
/*-----------------------------------------------------------------------*/
inline static Entry* ListAdd (List* list, void* reference)
/*-----------------------------------------------------------------------*/
{
  Entry* entry;

  if (list == NULL) return (NULL);

  entry = (Entry*) malloc (sizeof (Entry));
  
  entry->previous  = NULL;
  entry->next      = NULL;
  entry->list      = list;
  entry->reference = reference;

  if (list->last != NULL)
    {
      list->last->next = entry;
    }
  else
    {
      list->first = entry;
    }
  
  entry->previous = list->last;
  list->last = entry;

  return (entry);
}

/*-----------------------------------------------------------------------*/
inline static Entry* ListFind (List* list, void* reference)
/*-----------------------------------------------------------------------*/
{
  Entry* result = NULL;
  Entry* entry;

  if (list == NULL) return (NULL);
  if (reference == NULL) return (NULL);

  entry = list->first;
  while (entry != NULL)
    {
      if (entry->reference == reference)
        {
          result = entry;
          break;
        }
      entry = entry->next;
    }

  return (result);
}

/*-----------------------------------------------------------------------*/
inline static void EntryDelete (Entry* entry)
/*-----------------------------------------------------------------------*/
{
  List* list;
  Entry* previous;
  Entry* next;

  if (entry == NULL) return;

  previous = entry->previous;
  next = entry->next;
  list = entry->list;
  
  if (previous != NULL) previous->next = next;
  else if (list != NULL) list->first = next;
  
  if (next != NULL) next->previous = previous;
  else if (list != NULL) list->last = previous;

  entry->previous = NULL;
  entry->next = NULL;
  entry->list = NULL;
  entry->reference = NULL;

  free (entry);
}

/*-----------------------------------------------------------------------*/
inline static void ListRemove (List* list, void* reference)
/*-----------------------------------------------------------------------*/
{
  Entry* entry;

  if (list == NULL) return;
  if (reference == NULL) return;

  entry = ListFind (list, reference);
  if (entry == NULL) return;

  EntryDelete (entry);
}

/*-----------------------------------------------------------------------*/
inline static void ListClear (List* list)
/*-----------------------------------------------------------------------*/
{
  Entry* entry;

  if (list == NULL) return;

  while ((entry = list->first))
    {
      EntryDelete (entry);
    }
}

/*-----------------------------------------------------------------------*/
inline static void* ListFirst (List* list)
/*-----------------------------------------------------------------------*/
{
  Entry* entry;

  if (list == NULL) return (NULL);

  entry = list->first;
  if (entry == NULL) return (NULL);

  return (entry->reference);
}

/*-----------------------------------------------------------------------*/
inline static void* ListPopFirst (List* list)
/*-----------------------------------------------------------------------*/
{
  Entry* entry;
  void* reference;

  if (list == NULL) return (NULL);

  entry = list->first;
  if (entry == NULL) return (NULL);

  reference = entry->reference;

  EntryDelete (entry);

  return (reference);
}

/*-----------------------------------------------------------------------*/
inline static void* ListTop (List* list)
/*-----------------------------------------------------------------------*/
{
  Entry* entry;

  if (list == NULL) return (NULL);

  entry = list->last;
  if (entry == NULL) return (NULL);

  return (entry->reference);
}

/*-----------------------------------------------------------------------*/
inline static void* ListPop (List* list)
/*-----------------------------------------------------------------------*/
{
  Entry* entry;
  void* reference;

  if (list == NULL) return (NULL);

  entry = list->last;
  if (entry == NULL) return (NULL);

  reference = entry->reference;

  EntryDelete (entry);

  return (reference);
}

/*-----------------------------------------------------------------------*/
inline static int ListCount (List* list)
/*-----------------------------------------------------------------------*/
{
  Entry* entry;
  int count = 0;

  if (list == NULL) return (0);

  entry = list->first;
  while (entry != NULL)
    {
      count++;
      entry = entry->next;
    }

  return (count);
}

void CmMessageHandleInstall  (CmHandle* handle);
void CmMessageHandleUninstall  (CmHandle* handle);
void CmMessageHandleClear  (CmHandle* handle);
void CmMessageHandleSet  (CmHandle* handle, CmMessage message);
CmMessage CmMessageHandleGet  (CmHandle* handle);
void CmMessageHandleClearAll  (CmMessage message);
void CmConnectHandleInstall  (CmHandle* handle);
void CmConnectHandleUninstall  (CmHandle* handle);
void CmConnectHandleClear  (CmHandle* handle);
void CmConnectHandleSet  (CmHandle* handle, CmConnect connect);
CmConnect CmConnectHandleGet  (CmHandle* handle);
void CmConnectHandleClearAll  (CmConnect connect);
void CmCvtHandleInstall  (CmHandle* handle);
void CmCvtHandleUninstall  (CmHandle* handle);
void CmCvtHandleClear  (CmHandle* handle);
void CmCvtHandleSet  (CmHandle* handle, Cvt cvt);
Cvt CmCvtHandleGet  (CmHandle* handle);
void CmCvtHandleClearAll  (Cvt cvt);
void CmIteratorHandleInstall  (CmHandle* handle);
void CmIteratorHandleUninstall  (CmHandle* handle);
void CmIteratorHandleClear  (CmHandle* handle);
void CmIteratorHandleSet  (CmHandle* handle, CmMessageIterator iterator);
CmMessageIterator CmIteratorHandleGet  (CmHandle* handle);
void CmIteratorHandleClearAll  (CmMessageIterator iterator);

#ifdef __cplusplus
}
#endif

#endif
