#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/times.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <CmMessage.h>

static int connected = 1;
static int sent = 0;
static int c0;
static double s0;
static double cps = 1.0/60.0;

/*------------------------------------------------*/
static void disconnect (CmConnect c)
/*------------------------------------------------*/
{
  char* name = CmConnectGetName (c);

  printf ("Disconnection of %s\n", name);
  if ((name != 0) && (!strcmp (name, "tsb")))
    {
      connected = 0;
    }
}

/*------------------------------------------------*/
static CmMessageStatus stop_handler (CmMessage m, char* sender, char* server)
/*------------------------------------------------*/
{
  printf ("tsa: Stop received\n");

  return (CmMessageBreak);
}



/*------------------------------------------------*/
static void send (int* array, CmMessageArrayType type, int size)
/*------------------------------------------------*/
{
  CmMessage m;
  struct tms mytms;
  clock_t c;
  double s;

  c = times (&mytms);
  s = (double) (c - c0) * cps;

  m = CmMessageNew ();
  CmMessageSetType (m, "tsa");
  CmMessagePutInt (m, sent);
  CmMessagePutDouble (m, s);
  if (array != 0) CmMessagePutArray (m, type, size, array);

  if (CmMessageSend (m, "tsb"))
    {
      sent++;
    }

  CmMessageDelete (m);
}

/*------------------------------------------------*/
static CmMessageStatus ack_handler (CmMessage m, 
                                    char* sender, 
                                    char* server)
/*------------------------------------------------*/
{  
  double s1;
  double s2;
  double s3;
  int i;
  int* array = 0;
  CmMessageArrayType type;
  int size = 0;

  static double old_s = 0;
  static int old_number = 0;

  i = CmMessageGetInt (m);
  s1 = CmMessageGetDouble (m);
  s2 = CmMessageGetDouble (m);
  s3 = CmMessageGetDouble (m);
  if (CmMessageGetItemType (m) == CmMessageItemArray)
    {
      array = CmMessageGetArray (m, &type, &size);
    }

  if (sent == 5000){
	  return (CmMessageBreak);
  }

  if ((sent % 1000) == 0)
    {
      double rate = (double) (i - old_number) / (s1 - old_s);
      printf ("ack %d received rate=%d s1=%d s2=%d s3=%d\n", 
              i, (int) rate, (int) s1, (int) s2, (int) s3);
      old_s = s1;
      old_number = i;
    }
  if ( connected == 1) {
     send (array, type, size);
  }

  return (CmMessageOk);
}

/*------------------------------------------------*/
int main (int argc, char* argv[])
/*------------------------------------------------*/
{
  int i = 0;
  int size = 1;
  int* buffer = 0;
  struct tms mytms;

    /*
      Change this variable as follows :

      cyclic_loops = 1 
        tsa sends to tsb which sends to tsc which sends back to tsa
        then tsa loops again (triangular cycle)

      cyclic_loops = 0
        tsa sends messages continuously to tsb (which sends them to tsc)
        but tsa does not receive messages from tsc.
        the loop is unconditional
    */

  int cyclic_loops = 1;

  if (argc > 1)
    {
      sscanf (argv[1], "%d", &size);
    }

  CmMessageOpenMultipleServer ("tsa");

  CmConnectInstallDisconnectionHandler (disconnect);

  CmMessageInstallHandler (stop_handler, "stop");


  if (cyclic_loops)
    {
      CmMessageInstallHandler (ack_handler, "ack");
    }

  if (size > 1)
    {
      buffer = (int*) malloc (size * sizeof(int));
      for (i = 0; i < size; i++)
        {
          buffer[i] = i;
        }
    }

  sent = 1;

  c0 = times (&mytms);
  s0 = 0;

  if (cyclic_loops)
    {
      if ( connected == 1) {
         send (buffer, CmMessageInt, size);
      }
      CmMessageWait ();
    }
  else
    {
      for (i = 0; i < 5; i++)
        {
          clock_t c;
          double s;
          static double old_s = 0;
          static int old_number = 0;
          
          c = times (&mytms);
          s = (double) (c - c0) * cps;
          
          if ((sent % 1000) == 0)
            {
              double rate = (double) (sent - old_number) / (s - old_s);
              printf ("ack %d received rate=%d s=%d\n", 
                      i, (int) rate, (int) s);
              old_s = s;
              old_number = sent;
            }
          
          if ( connected == 1) {
             send (buffer, CmMessageInt, size);
	  }
        }
    }

  return EXIT_SUCCESS;
}
