#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <Reg.h>

int main (int argc, char* argv[])
{
  char* pattern;
  char* text;
  RegExp exp;

  if (argc < 3)
    {
      printf ("Usage>\n");
      printf (" > texp <pattern> <text>\n");
      return (0);
    }

  pattern = argv[1];
  text = argv[2];

  exp = RegExpNew (pattern);

  printf ("Exp : ");
  RegExpDump (exp);
  printf ("\n");

  if (RegExpMatch (exp, text))
    {
      printf ("Length = %d\n", RegExpLength ());
      printf ("At pos = %d\n", RegExpIndex ());
    }
  else
    {
      printf ("No match.\n");
    }

  return EXIT_SUCCESS;
}


