/*---------------------------------------------------------------------------*/
/*        Copyright (c) 1996 LAL Orsay, UPS-IN2P3-CNRS (France).             */
/*                                                                           */
/* Redistribution and use in source and binary forms, with or without        */
/* modification, are permitted provided that the following conditions        */
/* are met:                                                                  */
/* 1. Redistributions of source code must retain the above copyright         */
/*    notice, this list of conditions and the following disclaimer.          */
/* 2. Redistributions in binary form must reproduce the above copyright      */
/*    notice, this list of conditions and the following disclaimer in the    */
/*    documentation and/or other materials provided with the distribution.   */
/* 3. All advertising materials mentioning features or use of this software  */
/*    must display the following acknowledgement:                            */
/*      This product includes software developed by the Computer Application */
/*      Development Group at LAL Orsay (Laboratoire de l'Accelerateur        */
/*      Linaire - UPS-IN2P3-CNRS).                                           */
/* 4. Neither the name of the Institute nor of the Laboratory may be used    */
/*    to endorse or promote products derived from this software without      */
/*    specific prior written permission.                                     */
/*                                                                           */
/* THIS SOFTWARE IS PROVIDED BY THE LAL AND CONTRIBUTORS ``AS IS'' AND       */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE     */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        */
/* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LAL OR CONTRIBUTORS BE      */
/* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR       */
/* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF      */
/* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS  */
/* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   */
/* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   */
/* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF    */
/* THE POSSIBILITY OF SUCH DAMAGE.                                           */
/*---------------------------------------------------------------------------*/
#include <CmMessage.h>
#include <stdio.h>

/*
  rebuild using :

  cc -o t2.exe -g -I$CMSRC -I$CSETSRC $CMLIBS t2.c

  Send MESSAGES "T2" messages to t.exe and receive "T" answers from it.

  The MESSAGES answer stops this program.

*/

#ifndef MESSAGES
#define MESSAGES 1
#endif

CmMessageStatus Handler (CmMessage message, char* sender, char* serverName);

int main (int argc, char* argv[])
{
  CmMessage answer;
  int i;

  CmMessageOpenMultipleServer ("t2");

  CmMessageInstallHandler ((CmMessageHandler) Handler, "T");

  answer = CmMessageNew ();

  CmMessageSetType (answer, "T2");

  for (i = 0; i < MESSAGES; i++)
    {
      CmMessageSend (answer, "t");
      /* if (i == 2) printf (0,0); */
    }

  CmMessageDelete (answer);

  CmMessageWait ();

  return (0);
}

CmMessageStatus Handler (CmMessage message, char* sender, char* serverName)
{
  static int n = 1;

  if (n == MESSAGES) return (CmMessageBreak);
  n++;

  if (n == 2) printf ("%s","");

  return (CmMessageOk);
}

