/*---------------------------------------------------------------------------*/
/*        Copyright (c) 1996 LAL Orsay, UPS-IN2P3-CNRS (France).             */
/*                                                                           */
/* Redistribution and use in source and binary forms, with or without        */
/* modification, are permitted provided that the following conditions        */
/* are met:                                                                  */
/* 1. Redistributions of source code must retain the above copyright         */
/*    notice, this list of conditions and the following disclaimer.          */
/* 2. Redistributions in binary form must reproduce the above copyright      */
/*    notice, this list of conditions and the following disclaimer in the    */
/*    documentation and/or other materials provided with the distribution.   */
/* 3. All advertising materials mentioning features or use of this software  */
/*    must display the following acknowledgement:                            */
/*      This product includes software developed by the Computer Application */
/*      Development Group at LAL Orsay (Laboratoire de l'Accelerateur        */
/*      Linaire - UPS-IN2P3-CNRS).                                           */
/* 4. Neither the name of the Institute nor of the Laboratory may be used    */
/*    to endorse or promote products derived from this software without      */
/*    specific prior written permission.                                     */
/*                                                                           */
/* THIS SOFTWARE IS PROVIDED BY THE LAL AND CONTRIBUTORS ``AS IS'' AND       */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE     */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        */
/* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LAL OR CONTRIBUTORS BE      */
/* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR       */
/* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF      */
/* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS  */
/* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   */
/* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   */
/* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF    */
/* THE POSSIBILITY OF SUCH DAMAGE.                                           */
/*---------------------------------------------------------------------------*/
#ifndef __Cvt__
#define __Cvt__

#ifdef __cplusplus
extern "C" {
#endif

typedef char CvtSwap[(2*sizeof(short)) + 1 + (2*sizeof(int)) + 1];

typedef struct _CvtRec* Cvt;

void CvtForceStartup  ();
void CvtStartup  ();
void CvtCleanup  ();
void CvtCheckBalance  ();
Cvt CvtNew  (char* swap);
void CvtDelete  (Cvt cvt);
short CvtGetShort  (Cvt cvt, unsigned char* address);
void CvtPutShort  (short value, unsigned char* address);
int CvtGetInt  (Cvt cvt, unsigned char* address);
void CvtPutInt  (int value, unsigned char* address);
void CvtPutFloat  (float value, unsigned char* address);
float CvtGetFloat  (unsigned char* address);
void CvtPutFloats  (unsigned char* address, int elements);
void CvtGetFloats  (unsigned char* address, int elements);
void CvtPutDouble  (double value, unsigned char* address);
double CvtGetDouble  (unsigned char* address);
void CvtPutDoubles  (unsigned char* address, int elements);
void CvtGetDoubles  (unsigned char* address, int elements);
char* CvtToText  (Cvt cvt);
char* CvtGetSwap  ();

#ifdef __cplusplus
}
#endif

#endif
