#ifndef __CmTransaction_h__
#define __CmTransaction_h__

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _CmTransactionRec* CmTransaction;

typedef enum
{
  CmTransactionClosed,
  CmTransactionPending,
  CmTransactionTerminated
} CmTransactionState;

typedef enum
{
  CmTransactionOk,
  CmTransactionNotFound,
  CmTransactionAlreadyClosed
} CmTransactionStatus;

int CmOpenTransaction  (const char* info, void* object);
CmTransactionStatus CmCloseTransaction  (int id);
CmTransactionStatus CmTerminateTransaction  (int id);
CmTransactionStatus CmRestartTransaction  (int id);
CmTransactionState CmGetTransactionState  (int id);
char* CmGetTransactionInfo  (int id);
void* CmGetTransactionObject  (int id);
int CmIsTransactionTerminated  (int id);
int CmTerminatedTransactionCount  ();
void CmDumpTransactions  ();

#ifdef __cplusplus
}
#endif

#endif
