/*---------------------------------------------------------------------------*/
/*        Copyright (c) 1996 LAL Orsay, UPS-IN2P3-CNRS (France).             */
/*                                                                           */
/* Redistribution and use in source and binary forms, with or without        */
/* modification, are permitted provided that the following conditions        */
/* are met:                                                                  */
/* 1. Redistributions of source code must retain the above copyright         */
/*    notice, this list of conditions and the following disclaimer.          */
/* 2. Redistributions in binary form must reproduce the above copyright      */
/*    notice, this list of conditions and the following disclaimer in the    */
/*    documentation and/or other materials provided with the distribution.   */
/* 3. All advertising materials mentioning features or use of this software  */
/*    must display the following acknowledgement:                            */
/*      This product includes software developed by the Computer Application */
/*      Development Group at LAL Orsay (Laboratoire de l'Accelerateur        */
/*      Linaire - UPS-IN2P3-CNRS).                                           */
/* 4. Neither the name of the Institute nor of the Laboratory may be used    */
/*    to endorse or promote products derived from this software without      */
/*    specific prior written permission.                                     */
/*                                                                           */
/* THIS SOFTWARE IS PROVIDED BY THE LAL AND CONTRIBUTORS ``AS IS'' AND       */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE     */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        */
/* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LAL OR CONTRIBUTORS BE      */
/* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR       */
/* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF      */
/* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS  */
/* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   */
/* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   */
/* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF    */
/* THE POSSIBILITY OF SUCH DAMAGE.                                           */
/*---------------------------------------------------------------------------*/
#include <stdio.h>
#include <fcntl.h>
#include <sys/time.h>

#include <CmMessage.h>

void CmStdinSetup ();

static int WaitForStdinOrTimeout (float secs);
static CmConnectStatus CmStdinHandler (CmConnect connect);

static CmConnectStatus CmStdinHandler (CmConnect connect)
{
  static char buffer[512];
  char* buf;
  int pos;
  
  while ( WaitForStdinOrTimeout(0.25) &&
          (buf = gets (buffer)) )
    {
      printf ("%s\n", buf);
    }
  if (!buf)
    {
      exit (0);
    }

  return (CmConnectStatusNoData);
}

void CmStdinSetup ()
{
  CmConnect connect;
  
  connect = CmConnectNewWithSocket ("Stdin", 0);
  CmConnectInitHandlers (connect, CmStdinHandler, NULL);
}

static int WaitForStdinOrTimeout (float secs)
{
  fd_set r_mask;
  int result;
  
  FD_ZERO (&r_mask);
  do
    {
      struct timeval timev;
      timev.tv_sec = secs;
      timev.tv_usec = (secs - timev.tv_sec)*1e6;
      
      FD_SET(0, &r_mask);
      result = select (1, &r_mask, NULL, NULL, &timev);
      if ( !result ) return 0;
    } while (result < 0);
  
  return 1;
}


