#!/bin/csh -f

if ( "$1" == "" ) then
  if ( $?CMDOMAIN ) then
    set domain = ( ${CMDOMAIN} )
  else
    echo "You should define a domain name, either as the argument"
    echo " to this procedure, or as the CMDOMAIN environment variable."
    echo "The available domains are defined in $CMMGR/CmDomains : "
    echo ""
    awk '{ print $1; }' $CMROOT/mgr/CmDomains
    exit 1
  endif
else
  set domain = ( $1 )
endif

set line = ( `grep '^'"${domain}"'[ ]' $CMMGR/CmDomains` )

if ( "$line" != "" ) then
  setenv CMDOMAIN              ${domain}

  echo "The domain $domain is now configured."
  exit 0
else
  echo "The domain $domain is not defined in the CmDomains file."
  echo "The available domains are defined in $CMMGR/CmDomains : "
  echo ""
  awk '{ print $1; }' $CMROOT/mgr/CmDomains
  exit 1
endif

