#include <stdio.h>
#include <CmMessage.h>

void my_handler (CmMessage message, char* sender,
                 char* serverName);

main()
{
  CmConnectCondition condition;
  
  if (!CmMessageOpenServer ("Client1"))
    {
      fprintf (stderr, "Declaration error.\n");
      return (0);
    }
  
  CmMessageInstallHandler (my_handler, "Image");
  
  condition = CmMessageWaitWithTimeout (1.0);
  
  switch (condition)
    {
      case CmConnectTimeoutDetection :
          /* The image did not come */
        break;
      case CmConnectBreakDetection :
          /* The image is arrived */
        break;
      case CmConnectNoHandler :
        break;
      case CmConnectErrorCondition :
        break;
    }
  
}

void my_handler (CmMessage message, char* sender,
                 char* serverName)
{
  char* text;
  
  text = CmMessageGetText  (message);
  CmMessageBreak ();
}
