Summary: Utilities for obtaining short-lived proxy certificates for LIGO
Name: ligo-proxy-utils
Version: 1.3.5
Release: 1%{?dist}
Source0: ligo-proxy-utils-%{version}.tar.gz
License: Unknown
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch: noarch
Url: https://wiki.ligo.org/AuthProject
Requires: globus-proxy-utils >= 3.10, bash, curl >= 7.19.7-26, libxslt >= 1.1.26-2, openssl >= 1.0.0-20, osg-ca-certs >= 1.40, krb5-workstation

%description
%{summary}

%prep
%setup -q

%build

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/bin
install --mode=0755 ligo-proxy-init $RPM_BUILD_ROOT/usr/bin/ligo-proxy-init

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(0755,root,root,-)
/usr/bin/ligo-proxy-init

%changelog
* Mon Dec 17 2018 Paul Hopkins <paul.hopkins@ligo.org> - 1.3.5-1
- Use 2048 bits for RFC 3820 compliant impersonation proxy
* Wed Nov 28 2018 Paul Hopkins <paul.hopkins@ligo.org> - 1.3.4-1
- Use addressbook.ligo.org to verify uid instead of ldap.ligo.org
* Wed Apr 12 2017 Paul Hopkins <paul.hopkins@ligo.org> - 1.3.3-1
- Remove shred and store intermediate files in /dev/shm if available
* Fri Dec 02 2016 Paul Hopkins <paul.hopkins@ligo.org> - 1.3.2-1
- Add option to specify certificate lifetime which now defaults to 11.5 days
* Tue Nov 22 2016 Paul Hopkins <paul.hopkins@ligo.org> - 1.3.1-1
- Add option to create RFC 3820 compliant impersonation proxy
* Mon Aug 01 2016 Paul Hopkins <paul.hopkins@ligo.org> - 1.3.0-1
- Remove LDAP user check
- Use "rm -P" to safely delete files on Mac OS X
* Mon Jun 13 2016 Paul Hopkins <paul.hopkins@ligo.org> - 1.2.5-1
- Allow Virgo members to use ligo-proxy-init
- Print LDAP lookup warning only in debug mode
* Wed Feb 17 2016 Paul Hopkins <paul.hopkins@ligo.org> - 1.2.4-1
- Perform LDAP lookup check on port 80
- Continue script if LDAP lookup check fails to run
* Thu Nov 05 2015 Paul Hopkins <paul.hopkins@ligo.org> - 1.2.3-1
- Fixed bugs in Kerberos support
- Modified user validity check to use unencrypted connection
* Thu Oct 15 2015 Paul Hopkins <paul.hopkins@ligo.org> - 1.2.2-1
- Modified group check to only whitelist LSC and LIGOLab
- Fixed invalid password warning
- Added explicit Kerberos support
- Added destroy option
* Mon Jul 20 2015 Paul Hopkins <paul.hopkins@ligo.org> - 1.2.1-1
- Added automatic failover for LIGO IdP servers
* Fri Jun 06 2014 Adam Mercer <adam.mercer@ligo.org) - 1.0.1-1
- Curl now asks for password directly
- Clears (DY)LD_LIBRARY_PATH environment variables
- Explicitly sets umask
- Checks user is not Virgo member
- Minor bugfixes
* Fri Feb 22 2013 Scott Koranda <scott.koranda@ligo.org> - 1.0.0-1
- Initial version.
